pro tvellipse, rmax, rmin, xc, yc, pos_ang, color, THICK=thick, DATA = data, $
		COLOR = thecolor
;+
; NAME:
;	TVELLIPSE
;
; PURPOSE:
;	Draw an ellipse on the current graphics device.
;
; CALLING SEQUENCE:
;	TVELLIPSE, rmax, rmin, xc, yc, [ pos_ang, color, THICK = ,/DATA]
;
; INPUTS:
;	RMAX,RMIN - Scalars giving the major and minor axis of the ellipse
;	XC,YC - Scalars giving the position on the TV of the ellipse center
;
; OPTIONAL INPUTS:
;	POS_ANG - Position angle of the major axis, measured counter-clockwise
;		from the X axis.  Default is 0.
;	COLOR - Scalar  giving intensity level to draw ellipse.   The color
;		can be specified either with this parameter or with the 
;		COLOR keyword.   Default is !P.COLOR
;
; OPTIONAL KEYWORD INPUT:
;	THICK - Scalar set to the thickness of the drawn ellipse, default = 1
;	DATA - if this keyword is set and non-zero, then the box width and
;		X,Y position center are interpreted as being in DATA 
;		coordinates.   Note that the data coordinates must have been 
;		previously defined (with a PLOT or CONTOUR call).
;	COLOR - Intensity value used to draw the circle.  Default = !P.COLOR
;
; RESTRICTIONS:
;	TVELLIPSE does not check whether the ellipse is within the boundaries
;	of the window.
;
;	The ellipse is evaluated at 40 points and connected by straight lines.
;
; NOTES:
;	Note that the position angle for TVELLIPSE (counter-clockwise from the
;	X axis) differs from the astronomical position angle (counter-clockwise
;	from the Y axis). 
;
; REVISION HISTORY:
;	Written  W. Landsman STX          July, 1989            
;	Converted to use with a workstation.  M. Greason, STX, June 1990
;-
 On_error,2                              ;Return to caller

 if N_params() lt 2 then begin
   print,'Syntax - tvellipse, rmax, rmin, xc, yc,[ pos_ang, color, THICK = 
   print,'                                COLOR = , /DATA ]'
   return
 endif

 if N_params() lt 4 then $
       cursor, xc, yc, /DEVICE, /NOWAIT      ;Get unroamed,unzoomed coordinates

 if (xc LT 0) or (yc LT 0) then begin
       message,'Position cursor in window ' + strtrim(!D.WINDOW,2) + $
              ' -- then hit mouse button',/INF
       cursor, xc, yc, /DEVICE, /WAIT
         message,'Ellipse is centered at (' + strtrim(xc,2) + ',' + $
		strtrim(yc,2) + ')',/INF
 endif

 if N_params() LT 5 then pos_ang = 0.    ;Default position angle
  if not keyword_set(TheColor) then begin
      IF N_Elements( Color ) eq 0 THEN Color = !P.COLOR
  endif else color = TheColor

 if not keyword_set(THICK) then thick = !P.THICK

 phi = 2*!pi*(indgen(40)/39.)             ;Will connect 40 points
 x =  rmax*cos(phi)                       ;Parameterized equation of ellipse
 y =  rmin*sin(phi)
 ang = pos_ang/!RADEG               	;Position angle in radians
 cosang = cos(ang)
 sinang = sin(ang)
 xprime = xc + x*cosang - y*sinang   	;Rotate to desired position angle
 yprime = yc + x*sinang + y*cosang

 if keyword_set(DATA) then $
 plots, xprime, yprime, /DATA, COLOR=color, THICK=thick	 else $ ;Draw ellipse.
 plots, xprime, yprime, /DEVICE, COLOR=color, THICK=thick	

 return
 end
