;** converts the utc structure to a 3 word array in the format:
;** 
;** [0] : TAI msw (each bit is 32 seconds >> 16)
;** [1] : TAI mwd (each bit is 32 seconds)
;** [2] : TAI lsw (fractional part of 32 seconds)
;** 
;** Note: fractional secs are dropped
;** 
FUNCTION UTC2TAI32, utc

   result = INTARR(3)

   tai = UTC2TAI(utc)
   i32 = LONG(tai / 32D)
   f32 = ISHFT(LONG(tai), 11)	;** fractional secs are dropped

   result(0) = FIX(ISHFT(i32,-16))
   result(1) = FIX(i32 AND 'ffff'xl)
   result(2) = FIX(f32 AND 'ffff'xl)

   RETURN, result

END
