;+
; Name:
;	get_ij
;
; Purpose: determine (i,j) indicies from a 1-d index of values
;
; Calling sequence:
;	ij=get_ij(v,nx)
; Inputs:
;	v  = index to convert
;       nx = first dimension of 2-d array from which v was derived
; Outputs:
;	ij = [i,j] ; i,j indicies of v.
; Procedure:
;	uses mod
; Modification history:
;       Written DMZ (ARC) Nov 1992

function get_ij,v,nx

on_error,1

if n_params() lt 2 then message,'syntax --> ij=get_ij(v,nx)'

return,[v mod nx, v/nx] & end

