/* Written by Stein Vidar Hagfors Haugan 1994 */
/* Adapded from Defines */

#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <strings.h>

#include "strutil.h"

#define STEST 0
#define TRUE 1

extern int set_infile(char *);
extern void close_infile(void);
extern char * getsymbol(void);

void cleanup()
{
  fprintf(stderr,"Cleaning up!\n");
  _exit(1);
}


void usage(void)
{
    fprintf(stderr,"Use: Callers function +path\n\n");
    fprintf(stderr,"or:  Callers function @list_of_files\n");
}

char * filename;
char * function;

void repsym(char *sym)
{
  if (STEST) printf("S:'%s'\n",*sym =='\n' ? "\\n" : sym);
}


void readfile()
{
  char *symbol;
  char *Symbol;

  symbol = getsymbol();
    
  if (symbol) {
    while (symbol) {
      repsym(symbol);
      if (eQ(symbol,function)) {
	printf("%s\n",filename);
	close_infile();
	return;
      }
      free(symbol);
      symbol = getsymbol();
    }
  }
  close_infile();
}



void do_atfile(char *atfilename)
{
  FILE *atfile;
  char atfileline[500];
  atfilename++;
  if (!(atfile=fopen(atfilename,"r"))) { 
    fprintf(stderr," Couln't open %s\n",atfilename);
  } else {
    filename=fgets(atfileline,500,atfile);
    while (!feof(atfile)) {
      atfileline[strlen(atfileline)-1] = '\00'; /* Delete '\n' */
      if (set_infile(filename)) readfile();
      filename = fgets(atfileline,500,atfile);
    }
  }
}


void do_path(char *pathstring)
{
  char *path,*pP;
  char *comm;
  char tmpfile[L_tmpnam+1];

  pathstring++;
  pP = path = Copy(pathstring);
  while (*path) {
    while (*pP && *pP!=':') pP++;         /* Search for delimiter... */
    *pP = '\00';                          /* End it.. */
    if (!strlen(path)) path = ".";
    if (*(pP-1) != '/') path = concat(path,"/");
    else path = Copy(path);
    tmpnam(tmpfile);
    
    comm=concat("find ",concat(path,concat(" -name '*.pro' -print >",
					   tmpfile))); 
    system(comm);
    do_atfile(tmpfile-1);
    unlink(tmpfile);
    if (*++pP=='+') ++pP;
    path = pP;
  }
}


void main(int argc,char * argv[])
{
  int i;

  if (argc < 2) {
    usage();
    cleanup();
  }

  function = ucstr(argv[1]);

  for (i=2; i<argc; i++) {
    filename = argv[i];
    if (*filename=='@') do_atfile(filename);
    else if (*filename=='+') do_path(filename);
    else if (set_infile(filename)) readfile();
  }
}   

