/* Written by Stein Vidar Hagfors Haugan 1993 */
/* SVHH, 9 July -94: */
/*   Fixed a bug that made the last symbol (in alphabetical order) */
/*   undetected by findsymbol() */
/* SVHH, 11-December -94 */
/*   Added the routine testsymbol() in order to eliminate as many false */
/*   reports as possible, by checking the context for assignments etc.. */

#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <strings.h>

#include "strutil.h"

#define FTEST 0
#define SLTEST 0
#define STEST 0
#define TRUE 1

extern int set_infile(char *);
extern void close_infile(void);
extern void freeze(void);
extern void restore(void);
extern void back_up(long n);
extern char * getsymbol(void);

void cleanup()
{
  _exit(1);
}


void usage(void)
{
    printf("Use: Calls definefile idlfile.pro\n\n");
}

char * filename;

void repsym(char *sym)
{
  if (STEST) printf("S:'%s'\n",*sym =='\n' ? "\\n" : sym);
}

typedef struct {
  char * Symbol;
  char called;
  char function;
} entry;


entry list[5000];
static int Nentries = 0;

int compar(entry *first, entry *second)
{
  return strcmp(first->Symbol,second->Symbol);
}


void readlist(char *filename)
{
  char * symbol;
  int i;

  if (!set_infile(filename)) {
    printf("Couldn't open define list\n");
    _exit(1);
  }
  symbol = getsymbol();
  while (symbol) {
    list[Nentries].Symbol = ucstr(symbol);
    if (SLTEST) printf("Read symbol :'%s'\n", *symbol=='\n' ? "\\n" : symbol);
    mfree(symbol);
    symbol = getsymbol();
    if (*symbol=='(') {
      list[Nentries].function=1;
      mfree(symbol);
      symbol=getsymbol();         /* Now it's a ")" */
      mfree(symbol);
      symbol=getsymbol();         /* Now it's a "\n" */
    } else list[Nentries].function=0;
    list[Nentries].called=0;
    mfree(symbol);
    symbol=getsymbol();
    Nentries++;
  }
  qsort(list,Nentries,sizeof(entry),compar);
  if (SLTEST) for (i=0; i<Nentries; i++) 
    printf("SL:'%s':%s\n",list[i].Symbol, list[i].function ? "()" : "");
}



entry * findsymbol(char *symbol)
{
  int i,cmp;
  int high,low;

  low = 0;
  high = Nentries-1;
  
  if (!isalpha(*symbol)) return (entry *) 0L;
  symbol = ucstr(symbol);
  i = (high+low)/2;
  while (high!=i && i!=low) {
    if (FTEST) printf("Comparing '%s' and '%s'",list[i].Symbol,symbol);
    cmp = strcmp(list[i].Symbol,symbol);
    if (!cmp) {
      if (FTEST) printf(" --FOUND!!\n");
      mfree(symbol);
      return(&list[i]);
    } else if (cmp > 0) {     /* List gt Symbol (move UP) */ 
      high=i;
      if (FTEST) printf(" --Going UP");
    } else {
      low=i;
      if (FTEST) printf(" --Going DOWN");
    }
    if (FTEST) printf("\n");
    i = (high+low)/2;
  }
  if (FTEST) printf("Exit, comparing '%s' and '%s'\n",list[i].Symbol,symbol);
  return EQ(list[i].Symbol,symbol) ? &list[i] 
        :  (EQ(list[i+1].Symbol,symbol) ? &list[i+1] : (entry *) 0L);
}
    

void showresults()
{
  int i;
  for (i=0; i<Nentries; i++)
    if (list[i].called==1) printf("%s%s\n",list[i].Symbol,
			       list[i].function ? "()" : "");
  for (i=0; i<Nentries; i++)
    if (list[i].called==-1) printf("%s%s?\n",list[i].Symbol,
			       list[i].function ? "()" : "");
}


void testsymbol(entry *e)
{
  char *nextsym;
  int parenthesis;
  long backup;
/* The "intelligence" comes here... */

  freeze();
  if (STEST) printf("Entering TESTSYMBOL\n");
  if (e->function) { /* Only recognize function calls with a parenthesis... */
    nextsym = getsymbol();
    if (*nextsym != '(' && *nextsym != ' ') {
      e->called = -2;                    /* Certainly NOT a call - no "(" */
    }
    if (*nextsym == ' ') {
      free(nextsym);
      repsym(nextsym = getsymbol());
      if (*nextsym != '(') e->called = -2; /* Certainly NOT a call - no "(" */
    }
    if (e->called >= 0) {   /* Parenthesis found -- check assignment "=" */
      parenthesis = 1;
      free(nextsym);
      while (parenthesis) {
	repsym(nextsym = getsymbol());
	if (STEST) printf("(%d), '%c'\n",parenthesis,*nextsym);
	if (*nextsym == '(') parenthesis++;
	if (*nextsym == ')') parenthesis--;
	free(nextsym);
      }
      repsym(nextsym=getsymbol());

      while (*nextsym != '\n' 
	     && *nextsym != ')' && *nextsym != ',' && *nextsym != '&') {
	if (*nextsym == '=') e->called = -2;  /* Certainly NOT a call - "=" */
	free(nextsym);
	repsym(nextsym=getsymbol());
      }
      if (e->called >= 0) e->called = 1;
    }
  } else {
    restore();
    repsym(nextsym=getsymbol()); /* Check assignment "=" */
    
    while (*nextsym != ',' && *nextsym != '\n' && *nextsym != '&') {
      if (*nextsym == '=') e->called = -2; /* NOT a call */
      free(nextsym);
      repsym(nextsym=getsymbol());
    }

    restore();
    back_up(backup=strlen(e->Symbol)+1);
    repsym(nextsym=getsymbol());

    while (*nextsym == ' ') {
      if (STEST) printf("Backed up %d, got '%c'",backup,*nextsym);
      free(nextsym);
      restore();
      back_up(++backup);
      repsym(nextsym=getsymbol());
    }

    if (*nextsym != '&' && *nextsym != '\n' && *nextsym != ':') {

      free(nextsym);
      restore();
      back_up(backup+2);
      repsym(nextsym=getsymbol());
      if (Eq("PRO",nextsym)) {       /* Test for "PRO" prefix */
	e->called = -2;
      }

      if (e->called > -2) {         /* Test for "COMMON" prefix */
	restore();
	back_up(backup+5);
	free(nextsym);
	repsym(nextsym=getsymbol());
	if (Eq("COMMON",nextsym)) {
	  /* e->called = 0; */
	} else if (e->called > -2) { /* Check for THEN/ELSE/DO */
	  restore();
	  back_up(backup + 1);
	  free(nextsym);
	  repsym(nextsym=getsymbol());
	  if (Eq("DO",nextsym)) e->called = 1;
	  else {
	    restore(); 
	    back_up(backup + 3);
	    free(nextsym);
	    repsym(nextsym=getsymbol());
	    if (Eq("THEN",nextsym) || Eq("ELSE",nextsym)) e->called = 1;
	    else e->called = -1;
	  }
	}
      }
      
    }
    
    if (e->called>=0) e->called = 1;
  }
  if (STEST) printf("Exiting TESTSYMBOL, %d\n",e->called);
  restore();
}




void readfile()
{
  char *symbol;
  char *prev;
  entry *e;

  prev = Copy("");
  symbol = getsymbol();
    
  if (!symbol) printf("The file appears to be empty!\n");
  else {
    while (symbol) {
      repsym(symbol);
      if (*prev!='.'  &&  (e=findsymbol(symbol))) 
	testsymbol(e); /* e->called = 1; */
      free(prev);
      prev = symbol;
      symbol=getsymbol();
    }
  }
  close_infile();
}



void main(int argc,char * argv[])
{
  FILE * atfile;
  int i;

  if (argc != 3) {
    usage();
    cleanup();
  }

  readlist(argv[1]);

  filename = argv[2];
  if (set_infile(filename)) {
    readfile();
    showresults();
  }
}
