/* Written by Stein Vidar Hagfors Haugan 1993 */
#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <strings.h>

#include "strutil.h"

#define STEST 0
#define TRUE 1

extern int set_infile(char *);
extern void close_infile(void);
extern char * getsymbol(void);

typedef struct {
  char * next;
  char * Symbol;
  char * def_file;
} entry;


static int conflict=0;
static int diffs=0;

static entry list[5000];
static int Nentries = 0;

void cleanup()
{
  fprintf(stderr,"Cleaning up!\n");
  _exit(1);
}


void usage(void)
{
    fprintf(stderr,"Use: Defines idlfile.pro\n\n");
    fprintf(stderr,"or:  Defines @list_of_files\n");
    fprintf(stderr,"or:  Defines +path\n");
    fprintf(stderr,"or:  Defines - +path\n");
}

char * filename;


void repsym(char *sym)
{
  if (STEST) printf("S:'%s'\n",*sym =='\n' ? "\\n" : sym);
}


void Register(char * Sym)
{
  int i;
  entry * eP;
  if (!conflict) return;
  for (i=0; i<Nentries; i++) {
    if (EQ(Sym,list[i].Symbol)) {
      eP = &list[i];
      while (eP->next) eP = (entry *) eP->next;
      eP->next = mmalloc(sizeof(entry));
      eP = (entry *) eP->next;
      eP->def_file = Copy(filename);
      eP->next = (char *) 0L;
      return;
    }
  }
  list[Nentries].next = (char *) 0L;
  list[Nentries].Symbol = Copy(Sym);
  list[Nentries].def_file=Copy(filename);
  Nentries++;
}


int compar(entry *first,entry *second)
{
  return strcmp(first->Symbol,second->Symbol);
}


void make_diffs(char *first,char *second)
{
  FILE *diff_file;
  char diff_filename[L_tmpnam];
  char comm[500];
  char diff_line[500];

  tmpnam(diff_filename);

  sprintf(comm,"diff %s %s > %s",first,second,diff_filename);
  printf("diff %s %s\n",first,second);
  system(comm);
  if (!(diff_file=fopen(diff_filename,"r"))) {
    fprintf(stderr,"Unable to read diff file!\n");
    return;
  } 
  fgets(diff_line,500,diff_file);
  while (!feof(diff_file)) {
    printf("%s",diff_line);
    fgets(diff_line,500,diff_file);
  }
  fclose(diff_file);
}


void print_conflicts(void)
{
  int i;
  char *comm;
  entry *eP;
  entry *prevP=(entry *)0L;

  qsort(list,Nentries,sizeof(entry),compar);

  for (i=0; i<Nentries; i++) {
    if (list[i].next) {
      printf("%s defined in:\n",list[i].Symbol);
      eP = &list[i];
      printf("%s\n",eP->def_file);
      while (eP) {
	prevP = eP;
	eP = (entry *) eP->next;
	if (eP) printf("%s\n",eP->def_file);
	if (eP && diffs) make_diffs(prevP->def_file,eP->def_file);
      }
    }
  }
}


void readfile()
{
  char *symbol;
  char *Symbol;

  symbol = getsymbol();
    
  if (!symbol)  ; /*printf("The file appears to be empty!\n"); */
  else {
    while (symbol) {
      repsym(symbol);
      if (eQ(symbol,"PRO")) {
	free(symbol);
	symbol = getsymbol();
	if (!*symbol || !*symbol==' ') continue; /* Spaces/tabs */
	repsym(symbol);
	free(symbol);
	if (!(symbol=getsymbol())) continue;
	if (!isalpha(*symbol) && !(*symbol=='_')) continue;
	Symbol = ucstr(symbol);
	if (!conflict) printf("%s\n",Symbol);
	else           Register(Symbol);
	free(Symbol);
	free(symbol);
      } else if (eQ(symbol,"FUNCTION")) {
	free(symbol);
	symbol = getsymbol();
	if (!*symbol || !*symbol==' ') continue; /* Spaces/tabs */
	repsym(symbol);
	free(symbol);
	if (!(symbol=getsymbol())) continue;
	if (!isalpha(*symbol) && !(*symbol=='_')) continue;
	Symbol = ucstr(symbol);
	if (!conflict) printf("%s()\n",Symbol);
	else           Register(Symbol);
	free(Symbol);
	free(symbol);
      } else if (symbol) free(symbol);
      symbol = getsymbol();
    }
  }
  close_infile();
}



void do_atfile(char *atfilename)
{
  FILE *atfile;
  char atfileline[500];
  atfilename++;
  if (!(atfile=fopen(atfilename,"r"))) { 
    fprintf(stderr," Couln't open %s\n",atfilename);
  } else {
    filename=fgets(atfileline,500,atfile);
    while (!feof(atfile)) {
      atfileline[strlen(atfileline)-1] = '\00'; /* Delete '\n' */
      if (set_infile(filename)) readfile();
      filename = fgets(atfileline,500,atfile);
    }
  }
}


void do_path(char *pathstring)
{
  char *path,*pP;
  char *comm;
  char tmpfile[L_tmpnam+1];

  pathstring++;
  pP = path = Copy(pathstring);
  while (*path) {
    while (*pP && *pP!=':') pP++;         /* Search for delimiter... */
    *pP = '\00';                          /* End it.. */
    if (!strlen(path)) path = ".";
    if (*(pP-1) != '/') path = concat(path,"/");
    else path = Copy(path);
    tmpnam(tmpfile);
    
    comm=concat("find ",concat(path,concat(" -name '*.pro' -print >",
					   tmpfile))); 
    system(comm);
    do_atfile(tmpfile-1);
    unlink(tmpfile);
    if (*++pP=='+') ++pP;
    path = pP;
  }
}


void main(int argc,char * argv[])
{
  int i;

  if (argc < 2) {
    usage();
    cleanup();
  }

  for (i=1; i<argc; i++) {
    filename = argv[i];
    if (*filename=='-') {
      conflict = 1;
      if (*++filename=='d') diffs=1;
    } else if (*filename=='@') do_atfile(filename);
    else if (*filename=='+') do_path(filename);
    else if (set_infile(filename)) readfile();
  }
  if (conflict) print_conflicts();
}   

