/* Written by Stein Vidar Hagfors Haugan 1993 */
#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <strings.h>

#include "strutil.h"

#define MAXSYMBOLS  2000

#define OSTEST 0
#define FTEST 0
#define CTEST 0
#define SPTEST 0
#define MALLOCTEST 0

extern void cleanup();

/*********************************************************************
 *  UPPER/LOWER CASING OF SYMBOLS - READS ./.Nicerc or ~/.Nicerc
 ********************************************************************/


static char *casesymbols[MAXSYMBOLS];      /* Upper/lower case definitions */
static char *CASESYMBOLS[MAXSYMBOLS];      /* Their upper case equivalents */
static int Ncasesymbols=0;

/*
 *  Read  upper/lower case definition file *
 */

void readcasesymbols() 
{
  char * homedir;
  char inbuffer[500];
  char *p;
  FILE * casefile;

  Ncasesymbols=0;
  if (!(casefile=fopen(".Nicerc","r"))) {
    if (!( (int) (homedir = getenv("HOME"))
	  && (int)(casefile=fopen(concat(homedir,"/.Nicerc"),"r"))))
      if (!( (int) (homedir = getenv("CDS_C_PROG"))
	    && (int)(casefile=fopen(concat(homedir,"/.Nicerc"),"r")))) ;
  }
  if (casefile) {
    while (!feof(casefile)) {
      if (p= Copy(fgets(inbuffer,500,casefile))) {
	*(p+strlen(p)-1)='\00';
	if (*p=='#') continue;
	casesymbols[Ncasesymbols] = p;
	CASESYMBOLS[Ncasesymbols++] = ucstr(p);
	if (CTEST) printf("C:%d:'%s'\n",Ncasesymbols-1,p ? p : "(null)");
      }
    }
    fclose(casefile);
  }
}



/*
 * Replace a symbol with its upper/lower case definition *
 */

char * casesymbol(char *sym)
{
  int i;
  char *SYM;
  SYM = ucstr(sym);
  for (i=0; i<Ncasesymbols; i++)
    if (!strcmp(CASESYMBOLS[i],SYM)) {
      free(SYM);
      return Copy(casesymbols[i]);
    }
  free(SYM);
  return Copy(sym);
}
