/* Written by Stein Vidar Hagfors Haugan 1993 */
#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <strings.h>

#include "strutil.h"

#define OSTEST 0
#define FTEST 0
#define CTEST 0
#define SPTEST 0
#define MALLOCTEST 0

extern void cleanup();

extern void readcasesymbols(void);
extern char * casesymbol(char *);


/*********************************************************************
 * OUTPUT ACCUMULATION + INDENTATION + FLUSHING
 *
 * set_outfile(filename) -- Returns 0 on failure
 * 
 * outsym(symbol)        -- Add a symbol to the current line.
 *
 * flush_line(indent)    -- Flush a line to file with indentation.
 *
 * close_outfile()       --
 ********************************************************************/

static char *symbols[200];           /* The symbols on one line */
static int Nsymbols=0;

static FILE *outfile;

static int lastch=0;                 /* The change in the indentation */
                                     /* of the previous line          */

static int continued=0;              /* Is next line a continuation?   */

static int lineno=0;


/*
 * Counts the number of spaces in this symbol (ret. 0 if none) *
 */

static int countspaces(char *l)
{
  int n;
  n=0;
  while (*l && (*l=='\t' || *l==' ')) {
    if (*l=='\t') n = ((n/8)+1)*8;
    else n++;
    l++;
  }
  return n;
}


/*
 * Sets the output file - returns FALSE on error
 */

int set_outfile(char *filename)
{
  if (!(outfile=fopen(filename,"w"))) {
    printf("Error opening output file!\n");
    return 0;
  }
  readcasesymbols();
  return -1;
}



/*
 * Close ouput file -- FALSE on error *
 */

int close_outfile()
{
  return fclose(outfile) != EOF;
}



/*
 * Output one symbol to line buffer *
 */

void outsym(char *sym)
{
  if (OSTEST) printf("OS%d:'%s'\n",Nsymbols,sym);
  symbols[Nsymbols++] = sym;
}



/*
 * Takes care of tabbing and upper/lower casing.
 */

char * fixsymbol(int poscnt, char * sym)
{
  int nspaces;
  if (*sym==' ' && (nspaces=strlen(sym)) > 2) return tabspaces(poscnt,nspaces);
  else           return casesymbol(sym);
}


/*
 * Flush a line to the output file *
 *
 */

int flush_line(int spaces)
{
  int i;
  int poscnt=1;
  char *fix;

  lineno++;

  if (continued                                  /* If it's a continuation */
      || (Nsymbols>1                             /* or spaces + comment */
	  && *symbols[0]==' ' && *symbols[1]==';'))
    spaces = countspaces(symbols[0]) + lastch;   /* then shift relative */
  else if (Nsymbols && *symbols[0]==';')         /* If it's just a comment */
    spaces = countspaces(symbols[0]);            /* Then don't shift! */

  continued = 0;                                    /* no longer continued */

  fprintf(outfile,"%s",blanks(spaces));
  if (FTEST) printf("FLUSH:\n%s",blanks(spaces));

  poscnt = spaces;

  if (Nsymbols>0 && (*symbols[0]==' ' || *symbols[0]=='\t'))
      lastch = spaces - countspaces(symbols[0]);
  else
      lastch = spaces;

  if (*symbols[0]==' ' || *symbols[0]=='\t') {
    mfree(symbols[0]);
    i=1;
  } else i=0;

  while (i<Nsymbols) {
    if (i<Nsymbols-1 || (*symbols[i]!=' ' && *symbols[i]!='\t'))  {
      if (*symbols[i]=='$') continued = -1;
      fix = fixsymbol(poscnt,symbols[i]);
      fprintf(outfile,"%s",fix);

      poscnt += strlen(symbols[i]);
      
      if (FTEST) printf("%s",fix);
      mfree(fix);
    }
    mfree(symbols[i]);
    i++;
  }

  fprintf(outfile,"\n");
  if (poscnt > 80) printf("Line %d longer than 80 characters!\n",lineno);
  if (FTEST) printf("**=%d char's\n",poscnt);
  Nsymbols=0;
}



