/* Written by Stein Vidar Hagfors Haugan 1993 */
#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <strings.h>

#include "strutil.h"

#define STEST 0
#define PTEST 0
#define MALLOCTEST 0

extern int set_infile(char *);
extern int set_outfile(char *);
extern int close_outfile();
extern void outsym(char *);
extern void flush_line(int);
extern void flush_relative(int);
extern char * getsymbol(void);


/********************************************************************
 * IDL SYNTAX PARSING + BLOCK LEVEL INDENTING                       *
 *                                                                  *
 * For a change of indentation rules, change indent_value()         *
 *******************************************************************/

static int PBLEVEL = 0;

int isendsym(char *symbol)
{
  int res;
  symbol = ucstr(symbol);
  res =  EQ(symbol,"END") || EQ(symbol,"ENDIF") ||
         EQ(symbol,"ENDELSE") || EQ(symbol,"ENDCASE") ||
	 EQ(symbol,"ENDFOR") || EQ(symbol,"ENDWHILE") ||
	 EQ(symbol,"ENDREP");
  mfree(symbol);
  return res;
}


int isstartsym(char *symbol)
{
  return eq(symbol,"BEGIN") || eq(symbol,"CASE") ||
	     eq(symbol,"PRO") || eq(symbol,"FUNCTION");
}


int indent_value(char *symbol)
{
  int res;
  if (!symbol) return 0;
  if (PTEST) printf("indent_value('%s')\n",symbol ? symbol : "(null)");
  symbol = ucstr(symbol);
  if (EQ(symbol,"BEGIN") || EQ(symbol,"CASE")) res=4;
  else if (EQ(symbol,"PRO") || EQ(symbol,"FUNCTION")) res=2;
  else res=0;
  mfree(symbol);
  return res;
}

char *parse_block(char *,int);


char * parse_line(int level)
{
  char * symbol;
  symbol = getsymbol();

  if (PTEST) printf("PL%sINN:%s\n",blanks(level), 
			symbol ? symbol : "(null)");

  while (symbol && *symbol != '\n') {
    if (eq(symbol,"BEGIN") || eq(symbol,"CASE") ||
	     eq(symbol,"PRO") || eq(symbol,"FUNCTION"))  {
      parse_block(symbol,level); 
    } else if (isendsym(symbol)) return symbol;
    else outsym(symbol);
    symbol = getsymbol();
  }
  return symbol;
}



char * parse_block(char * starter, int level)
{
  char * ender,*oldender;
  static char newline[]="\n";

  if (PTEST)     printf("PB%sINN:%s\n",blanks(level), 
			starter ? starter : "(null)");

  if (starter) { outsym(starter); starter = Copy(starter); }
  ender = parse_line(level+indent_value(starter));
  flush_line(level);
  while (ender && !isendsym(ender)) {
    oldender=ender;                   /* Keep handle 'till after flush_line */
    ender = parse_line(level+indent_value(starter));
    if (ender && !isendsym(ender)) flush_line(level+indent_value(starter));
    mfree(oldender);
  }
  if (ender) outsym(ender);
  if (PTEST)     printf("PB%sOUT:%s\n",blanks(level),
			starter ? starter : "(null)");
  mfree(starter);
  return ender;
}
