/* Written by Stein Vidar Hagfors Haugan 1993 */
/* SVHH, 11-December -94 Added freeze()/restore()/back_up()  */

#include <stdlib.h>
#include <ctype.h>
#include <memory.h>
#include <stdio.h>
#include <strings.h>

#include "strutil.h"

#define STEST 0
#define MALLOCTEST 0

extern void cleanup();

/***********************************************************************
 *               SYMBOL GENERATOR MODULE                               *
 *
 *  set_infile(filename)   -- returns zero on failure
 *
 *  char *getsymbol()      -- returns NULL on EOF
 *
 *  close_infile()         --
 *
 *  freeze()               -- Store current file position
 *
 *  restore()              -- Restore file position from previous freeze()
 *
 *  back_up(long)          -- Back up n bytes in the file from current pos.
 *
 **********************************************************************/

static FILE * infile;
static long freeze_pos;

static int colcnt=0;
static int freeze_colcnt;

static char *readcomment(FILE *file, char c)
{
  char buffer[500];
  char *bP;
  bP = buffer;
  while (c != '\n' && !feof(file)) {
    *bP++ = c;
    c = fgetc(file);
  }
  ungetc(c,file);
  *bP = '\00';
  colcnt += strlen(buffer);
  return Copy(buffer);
}



static char *readspaces(FILE *file, char c)
{
  char buffer[500];
  char *bP;
  bP = buffer;
  while (c == ' ' || c=='\t') {
    if (c=='\t') {
      *bP++ = ' ';
      while ((colcnt+bP-buffer)%8) *bP++=' ';
    } else   *bP++ = c;
    c = fgetc(file);
  }
  ungetc(c,file);
  *bP = '\00';
  colcnt += strlen(buffer);
  if (STEST) printf("Spaces:%d, up to pos %d\n",strlen(buffer),colcnt);
  return Copy(buffer);
}



static char *readidentifier(FILE *file, char c)
{
  char buffer[500];
  char *bP;
  bP = buffer;
  while (isalnum(c) || c=='_') {
    *bP++ = c;
    c = fgetc(file);
  }
  ungetc(c,file);
  *bP = '\00';
  colcnt += strlen(buffer);
  return Copy(buffer);
}



static char *readnumber(FILE *file, char c)
{
  char buffer[500];
  char *bP;
  bP = buffer;
  while (isdigit(c) || c=='.') {
    *bP++ = c;
    c = fgetc(file);
  }
  ungetc(c,file);
  *bP = '\00';
  colcnt += strlen(buffer);
  return Copy(buffer);
}


/* READS '''HELLO''' AS 3 STRINGS: '' + 'HELLO' + '' */

static char *readstring(FILE *file, char c)
{
  char buffer[500];
  char *bP;
  bP = buffer;
  *bP++ = c;
  c = fgetc(file);
  while (c!=buffer[0] && c!='\n') {
    *bP++ = c;
    c = fgetc(file);
  }
  if (c=='\n') ungetc(c,file);
  else *bP++ = c;
  *bP = '\00';
  colcnt += strlen(buffer);
  return Copy(buffer);
}



/* CHARACTER '"' MAY BE THE START OF AN OCTAL CONSTANT */

static char *readstringoroctal(FILE *file, char c)
{
  char buffer[500];
  char *bP;
  bP = buffer;
  *bP++ = c;
  c = fgetc(file);
  if (isdigit(c)) {         /* IT'S AN OCTAL CONST */
    while (isdigit(c)) {
      *bP++ = c;
      c = fgetc(file);
    }
    ungetc(c,file);
  } else {
    while (c!=buffer[0] && c!='\n') { /* IT'S A DOUBLE QUOTED STRING */
      *bP++ = c;
      c = fgetc(file);
    }
    if (c=='\n') ungetc(c,file);
    else *bP++ = c;
  }
  *bP = '\00';
  colcnt += strlen(buffer);
  return Copy(buffer);
}


char *Sreport(char *symbol)
{
  if (STEST) printf("S:'%s'\n", *symbol=='\n' ? "\\n" : symbol);
  return symbol;
}



char *getsymbol(void)
{
  char c;
  char singlechar[2];

  singlechar[1] = '\00';

  if feof(infile) {
    if (STEST) printf("Reporting end of file!\n");
    return (char *) 0L;
  }

  c = fgetc(infile);

  if feof(infile) {
    if (STEST) printf("Reporting end of file!\n");
    return (char *) 0L;
  }

  switch (c) {
  case ';':  return Sreport(readcomment(infile,c));
             break;
  case '\t':
  case ' ' : return Sreport(readspaces(infile,c));
             break;
  
  case '"' : return Sreport(readstringoroctal(infile,c));
             break;
  case '\'': return Sreport(readstring(infile,c));
             break;
  case '\n': colcnt=0;
             singlechar[0]=c;
             return Sreport(Copy(singlechar));
             break;
  default:   if (isalpha(c)||c=='_') return Sreport(readidentifier(infile,c));
             else if (isdigit(c) || c=='.') 
	       return Sreport(readnumber(infile,c));
             else {
	       singlechar[0]=c;
	       colcnt++;
	       return Sreport(Copy(singlechar));
	     }
  }
}


void freeze()
{
  freeze_pos = ftell(infile);
  freeze_colcnt = colcnt;
}


void restore()
{
  if (fseek(infile,freeze_pos,SEEK_SET)) {
    fprintf(stderr,"Error in seeking on input file\n");
    exit(1);
  }
  colcnt = freeze_colcnt;
}


void back_up(long n) /* Backing up one character */
{
  if (fseek(infile,-n,SEEK_CUR)) {
    fprintf(stderr,"Error in seeking on input file\n");
    exit(1);
  }
}

int set_infile(char *filename)
{
  if (!(infile=fopen(filename,"r"))) {
    fprintf(stderr,"Couln't open file '%s'\n",filename);
    return 0;
  }
  return -1;
}


void close_infile(void)
{
  fclose(infile);
}
