#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <strings.h>

#define TRUE 1
#define MALLOCTEST 0
#define SPTEST 0

static int Nblocks=0;

char * mmalloc(int size)
{
  char * p;

  Nblocks++;
  size = size+1; /* Alignment trick */
  if (!(p=malloc(size))) { printf("Allocation error!\n"); cleanup(); }
  if (MALLOCTEST) printf("NBlocks:%d\n",Nblocks);
  return ((long)p&1L) ? p+1 : p;
}


void mfree(char *p)
{
  Nblocks--;
  if (MALLOCTEST) printf("Freeing:%s\n",p);
  free(p);
}


/* STRING UTILITY */

char *Copy(char * s)
{
  char *p,*p2;
  if (!s) return s;
  p2 = p = mmalloc(strlen(s)+1);
  if (MALLOCTEST) printf("Copied:%s\n",s);
  if (!p2) { printf("Allocation error!\n"); cleanup(); }
  while (*s) *p++ = *s++;
  *p = *s;
  return p2;
}



char * concat(char * str1,char *str2)
{
  char *d;
  d = mmalloc(strlen(str1)+strlen(str2)+1);
  if (!d) { printf("Alloc error\n"); cleanup(); }
  *d = '\00';
  d = strcat( strcat(d,str1), str2);
  return d;
}

char * ucstr(char *l)
{
  char *p; 
  char * strip_text(char *);
  p = l = Copy(l);
  while (*p) { if (*p>='a' && *p<='z') *p &= ~('A' ^ 'a'); p++; }
  *p='\0';
  return l;
}

int Eq(char *A, char *b)
{
  int res;
  b = ucstr(b);
  res = !strcmp(A,b);
  mfree(b);
  return res;
}

int eQ(char *a, char *B)
{
  int res;
  a = ucstr(a);
  res = !strcmp(a,B);
  mfree(a);
  return res;
}



int EQ(char *A, char *B)
{
  return !strcmp(A,B);
}


int eq(char *a, char *b)
{
  int res;
  a = ucstr(a);
  b = ucstr(b);
  res = !strcmp(a,b);
  mfree(a);
  mfree(b);
  return res;
}


/*
 * Returns tabbed blanks for the beginning of the line *
 */

char *blanks(int n)
{
  static char blank[] = "                                               \
                                                                           ";
  static char buffer[100];
  int i;

  for (i=0; i<(n/8); i++) buffer[i]='\t';
  while (i< (n%8 + n/8)) { buffer[i++]=' '; }
  buffer[i] = '\00';
  return buffer;
}



/* 
 * Returns tabbed spaces in the middle of a line *
 */

char * tabspaces(int poscnt, int nspaces)
{
  char buffer[100], *bP=buffer;
  int targetpos=poscnt+nspaces;
  int pos_sofar;

  if (SPTEST) printf("<%d + %d = %d>=",poscnt,nspaces,targetpos);

  while (poscnt/8+(bP-buffer) != targetpos/8) *bP++ = '\t';
  if (bP!=buffer) pos_sofar = (targetpos/8)*8;
  else            pos_sofar = poscnt;
  while (pos_sofar++ < targetpos)  *bP++ = ' ';
  *bP='\00';
  if (SPTEST) printf("'%s'\n",buffer);
  return Copy(buffer);
}


/*
 * Counts the number of spaces in this symbol (ret. 0 if none) *
 */

int countspaces(char *l)
{
  int n;
  n=0;
  while (*l && (*l=='\t' || *l==' ')) {
    if (*l=='\t') n = ((n/8)+1)*8;
    else n++;
    l++;
  }
  return n;
}
