pro db_titles,fnames,titles
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	DB_TITLES
; Purpose     :	
;	Print database name and title.  Called by DBHELP
; Explanation :	
;	Print database name and title.  Called by DBHELP
; Use         :	
;	db_titles,fnames,titles
;
; Inputs      :	
;	fnames - string array of data base names
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	GETLOG
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	
;	Database name is printed along with the description in the .DBC file
;
; Category    :	Utilities, Database
;
; Prev. Hist. :	
;	version 2  W. Landsman May, 1989
;	modified to work under Unix, D. Neill, ACC, Feb 1991.
;
; Written     :	W. Landsman, GSFC/UIT, May 1989
;
; Modified    :	Version 1, William Thompson, GSFC, 29 March 1994
;			Incorporated into CDS library.
;		Version 2, William Thompson, GSFC/CDS (ARC), 1 June 1994
;			Added support for external (IEEE) representation.
;		Version 3, William Thompson, GSFC, 3 November 1994
;			Modified to allow ZDBASE to be a path string.
;
; Version     :	Version 3, 3 November 1994
;-
;
;-----------------------------------------------------------------------------
 n = N_elements(fnames)
 get_lun,unit
 b = bytarr(59)
 npar = N_params()
 if npar eq 2 then titles = strarr(n)
 for i = 0,n-1 do begin
     dbc_file = find_with_def(strtrim(fnames(i))+'.dbc', 'ZDBASE')
     openr,unit,dbc_file,error=err,/segmented
;
;  If /SEGMENTED doesn't work, then maybe the file was written in external
;  format.  Try /BLOCK instead.
;
     if err then openr,unit,dbc_file,error=err,/block
     if err lt 0 then $               ;Does database exist?
        printf,!TEXTUNIT,'Unable to locate database ',fnames(i) $
 else begin
        readu,unit,b
        if npar eq 1 then begin
            printf,!TEXTUNIT,format='(A,T20,A)',fnames(i),strtrim(b(19:58),2) 
        endif else titles(i) = string(b(19:58))
   endelse

   close,unit

 endfor

 free_lun,unit
 return
end
