pro dbclose,dummy
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	DBCLOSE
; Purpose     :	
;	Procedure to close a data base file
; Explanation :	
;	Procedure to close a data base file
; Use         :	
;	dbclose
;
; Inputs      :	None.
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	DB_INFO
;
; Common      :	DB_COM
;
; Restrictions:	None.
;
; Side effects:	
; 	The data base files currently opened are closed
;
; Category    :	Utilities, Database
;
; Prev. Hist. :	
;	version 2  D. Lindler  Oct. 1987
;	For IDL version 2      August 1990
;
; Written     :	D. Lindler, GSFC/HRS, October 1987
;
; Modified    :	Version 1, William Thompson, GSFC, 29 March 1994
;			Incorporated into CDS library
;		Version 2, William Thompson, GSFC/CDS (ARC), 30 May 1994
;			Added support for external (IEEE) data format
;
; Version     :	Version 2, 30 May 1994
;-
;
;------------------------------------------------------------------------
 On_error,2
 common db_com, QDB, QITEMS, QDBREC         ;Database common - see DBOPEN

 if N_elements(qdb) LT 120 then return	;No db opened
 ndb = db_info('NUMBER')		;number of data bases opened
 update = db_info('UPDATE',0)		;opened for update?

; If database open for update, write total number of entries in zeroeth record

 if update EQ 1 then begin		;update header
	output = [db_info('entries',0), db_info('seqnum',0)]
	if qdb(119) eq 1 then host_to_ieee, output	;External format?
        qdbrec(0) = byte(output,0,8)
 endif

 for i = 0, ndb-1 do begin		;loop on units (2 per data base)
        unit1 = qdb(96,i)			;unit numbers
        unit2 = qdb(97,i)			;unit numbers
	if unit1 gt 0 then free_lun,unit1       ;Is it opened?
	if unit2 gt 0 then free_lun,unit2       ;Is it opened?
 endfor

 qdb=0					;mark as closed

 return                                                              
 end
