pro dbext_ind,list,item,dbno,values
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	DBEXT_IND
; Purpose     :	
;	routine to read a indexed item values from index file
; Explanation :	
;	routine to read a indexed item values from index file
; Use         :	
;	dbext_ind,list,item,dbno,values
;
; Inputs      :	
;	list - list of entry numbers to extract values for
;		(if it is a scalar, values for all entries are extracted)
;	item - item to extract
;	dbno - number of the opened data base
;
; Opt. Inputs :	None.
;
; Outputs     :	
;	values - vector of values returned as function value
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	DB_INFO, DB_ITEM, DB_ITEM_INFO
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Utilities, Database
;
; Prev. Hist. :	
;	version 1  D. Lindler  Feb 88
;	Faster processing of string values    W. Landsman   April, 1992
;
; Written     :	D. Lindler, GSFC/HRS, February 1988
;
; Modified    :	Version 1, William Thompson, GSFC, 29 March 1994
;			Incorporated into CDS library
;		Version 2, William Thompson, GSFC/CDS (ARC), 30 May 1994
;			Added support for external (IEEE) data format
;
; Version     :	Version 2, 30 May 1994
;-
;
On_error,2
;
if N_params() LT 4 then begin
     print,'Syntax - dbext_ind, list, item, dbno, values'
     return
endif

; Determine first and last block to extract
;
s=size(list) & ndim=s(0)
if (ndim GT 0) then if (list(0) EQ -1) then ndim=0
zeros = 0				;flag if zero's present in list

if ndim EQ 0 then begin
	minl = 1
	maxl = db_info('ENTRIES',dbno)
    end else begin
	minl = min(list)
	if minl EQ 0 then begin	;any zero values in list
		zeros = 1
		nonzero = where(list GT 0)
		bad = where(list LE 0)
		minl = min(list(nonzero))
	endif
	maxl=max(list)
end
;
; get item info
;
db_item,item,it,ivalnum,dtype,sbyte,numvals,nbytes
nbytes = nbytes(0)
if N_elements(it) GT 1 then $
	message,'ERROR - Only one item can be extracted by dbext_ind'

itnum=db_item_info('itemnumber',it(0))	;item number in this dbno
;
; determine if indexed
;
index_type = db_item_info('index',it(0))
if index_type EQ 0  then $
	message,'ERROR - Requested item is not indexed'

if index_type EQ 3 then $
	message,'ERROR - Unsorted values of item not recorded in index file'
;
; get unit number of index file and read header info
;
unit=db_info('UNIT_DBX',dbno)
external = db_info('EXTERNAL',dbno)	;External (IEEE) data format?
p=assoc(unit,lonarr(2))
h=p(0)
if external then ieee_to_host,h
p = assoc(unit,lonarr(7,h(0)),8)
header = p(0)
if external then ieee_to_host,header
items = header(0,*)
pos = where(items EQ itnum) & pos=pos(0)
if !ERR LT 1 then $
	message,'Item not indexed, DBNO may be wrong'

;
; find starting location to read
;
if index_type NE 4 then sblock=header(4,pos) else sblock=header(6,pos)
;
sbyte = 512L*sblock
sbyte = sbyte+(minl-1L)*nbytes
nv = (maxl-minl+1L) ;number of bytes to extract
;            
; create mapped i/o variable
;
dtype = dtype(0)
if dtype NE 7 then $
   p = assoc(unit, make_array(size=[1,nv,dtype,0],/NOZERO), sbyte ) else $
   p = assoc(unit, make_array(size=[2,nbytes,nv,1,0],/NOZERO), sbyte )
;
; read values from file
; Modified, April 92 to delay conversion to string until the last step WBL
;
values = p(0)
if external then ieee_to_host,values
;
; if subset list specified perform extraction
;
if ndim NE 0 then begin
	if zeros then begin			;zero out bad values
		if dtype NE 7 then begin	;not a string?
  		        values = values( (list-minl)>0 )
			values(bad)=0
		   end else begin		        ;string 
                        values = values(*, (list-minl)>0 )
                        if N_elements(bad) EQ 1 then bad = bad(0)
			values(0,bad) = replicate( 32b, nbytes )
                   endelse
	   end else begin
		  if dtype EQ 7 then values = values(*, list-minl) $
                                else values = values( list-minl )
	end
end
if dtype EQ 7 then values = string(values)
return
end
