pro dbfind_entry,type,svals,nentries,values
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	DBFIND_ENTRY
; Purpose     :	
;	Performs an entry number search.  Subroutine of DBFIND.
; Explanation :	
;	This is a subroutine of dbfind and is not a standalone procedure
;	It performs a entry number search.
;
; Use         :	
;	dbfind_entry, type, svals, nentries, values
;
; Inputs      :	
;	type - type of search (output from dbfparse)
;	svals - search values (output from dbfparse)
;	values - array of values to search
;
; Opt. Inputs :	
;
; Outputs     :	
;	good - indices of good values
;	!err is set to number of good values
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Utilities, Database
;
; Prev. Hist. :	
;	D. Lindler  July,1987
;
; Written     :	D. Lindler, GSFC/HRS, July 1987
;
; Modified    :	Version 1, William Thompson, GSFC, 29 March 1994
;			Incorporated into CDS library
;
; Version     :	Version 1, 29 March 1994
;-
;
sv0=long(strtrim(svals(0),2)) & sv1=long(strtrim(svals(1),2))
if values(0) eq -1 then begin		;start with all entries
    case type of

	 0:  begin
		if (sv0 gt 0) and (sv0 lt nentries) then begin
			values=lonarr(1)+sv0
			!err=1
		   end else !err=-1
	     end
	-1: begin
		 values=lindgen(nentries-sv0+1) + sv0	;value>sv0
		!err=nentries-sv0+1
	    end
	-2: begin
		values= lindgen(sv1>1<nentries)+1	;value<sv1
		!err=sv1>1<nentries
	    end
	-3: begin					;sv0<value<sv1
	    if sv1 lt sv0 then begin
	        temp=sv0
		sv0=sv1
		sv1=temp
	    end
	    sv0=sv0>1<nentries
	    sv1=sv1>1<nentries
	    values=lindgen(sv1-sv0+1)+sv0
	    !err=sv1-sv0+1
	    end 	
	-5: begin				;sv1 is tolerance
	    minv=(sv0-abs(sv1))>1
	    maxv=(sv0+abs(sv1))<nentries
	    values=lindgen(maxv-minv+1)+minv
	    !err=maxv-minv+1
	    end
	-4: 					;non-zero
	else: begin				;set of values
	      sv=lonarr(type)
	      for i=0L,type-1 do sv(i)=long(strtrim(svals(i),2))
	      good=where((sv gt 0) and (sv le nentries),nfound)
	      if nfound gt 0 then values=sv(good)
	      end
    endcase
  end else begin					;input list supplied
    case type of
 
	0:  good=where(values eq sv0)		;value=sv0
	-1: good=where(values ge sv0)		;value>sv0
	-2: good=where(values le sv1)		;value<sv1
	-3: begin				;sv0<value<sv1
	    if sv1 lt sv0 then begin
	        temp=sv0
		sv0=sv1
		sv1=temp
	    end
	    good=where((values ge sv0) and (values le sv1))
	    end 	
	-5: begin				;sv1 is tolerance
	    minv=sv0-abs(sv1)
	    maxv=sv0+abs(sv1)
	    good=where((values ge minv) and (values le maxv))
	    end
	-4: good=where(values)			;non-zero
	else: begin				;set of values	
	      nf=0				;number found
	      for i=0L,type-1 do begin		;loop on possible values    
		g=where(values eq long(strtrim(svals(i),2)), nfound)
		if nfound gt 0 then begin
			if nf eq 0 then good=g else good=[good,g]
			nf=nf+nfound
		end
	      end
	      !err=nf
	      end
    endcase
    if !err le 0 then return
    values=values(good)
end
return
end
