FUNCTION dbindex_blk, unit, nb, bsz, ofb, dtype
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	DBINDEX_BLK()
; Purpose     :	
;	Set up associated variable in preparation for writing to file.
; Explanation :	
;	To set up an associated variable of the correct data-type and offset
;	into the file by some amount in preparation for writing to the file.
;
; Use         :	
;	res = dbindex_blk(unit, nb, bsz, ofb, dtype)
;
; Inputs      :	
;	unit   The unit number assigned to the file.
;	nb     The number of blocks to offset into the file.
;	bsz    The size of each block, in bytes, to offset into the file.
;	ofb    The offset into the block, in bytes.
;	dtype  The IDL datatype as defined in the SIZE function
;
; Opt. Inputs :	None.
;
; Outputs     :	
;	res    The returned variable.  This is an associated variable.
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	
;	The file must have been previously opened.
;
; Side effects:	None.
;
; Category    :	Utilities, Database.
;
; Prev. Hist. :	
;	Written by Michael R. Greason, STX, 14 June 1990.
;
; Written     :	Michael R. Greason, GSFC/UIT (STX), 14 June 1990
;
; Modified    :	Version 1, William Thompson, GSFC, 29 March 1994
;			Incorporated into CDS library
;
; Version     :	Version 1, 29 March 1994
;-
;
offset = long(nb) * long(bsz) + long(ofb)
case dtype of
	7: datarec=assoc(unit,bytarr(1),offset)		; string
	1: datarec=assoc(unit,bytarr(1),offset)		; byte
	2: datarec=assoc(unit,intarr(1),offset)		; integer
	4: datarec=assoc(unit,fltarr(1),offset)		; floating point
        3: datarec=assoc(unit,lonarr(1),offset)		; longword
        5: datarec=assoc(unit,dblarr(1),offset)		; double
        6: datarec=assoc(unit,complexarr(1),offset)	; complex
endcase
;
RETURN, datarec
END
