pro dbrd,enum,entry,available,dbno
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	DBRD
; Purpose     :	
;	Read an entry from a data base or linked multiple databases.
; Explanation :	
;	Procedure to read an entry from a data base file or from
;	linked multiple databases.
;
;	If multiple data base files are opened, the records are
;	concatenated with each other
;
; Use         :	
;	dbrd, enum, entry, [available, dbno]
;
; Inputs      :	
;	enum - entry number to read, integer scalar
;
; Opt. Inputs :	
;	dbno - specification of the data base number to return.  If
;		supplied, only the record for the requested data base
;		number is returned in entry.  Normally this input should
;		not be supplied.  dbno is numbered for 0 to n-1 and gives
;		the number of the data base opened.  The data bases are 
;		numbered in the order supplied to dbopen.  If dbno is supplied 
;		then the entry number refers to that data base and not the
;		primary or first data base. If set to -1, then it means all
;		data bases opened (same as not supplying it)
;
; Outputs     :	
;	entry - byte array containing the entry
;
; Opt. Outputs:	
;	available - byte array with length equal to number of data
;		bases opened.  available(i) eq 1 if an entry (pointed
;		to) is available.  It always equals 1 for the first 
;		data base, otherwise it is an error condition.
;
; Keywords    :	None.
;
; Calls       :	DB_INFO, DB_ITEM, DBXVAL
;
; Common      :	DB_COM
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Utilities, Database
;
; Prev. Hist. :	
;	version 2  D. Lindler  Nov. 1987
;
; Written     :	D. Lindler, GSFC/HRS, November 1987
;
; Modified    :	Version 1, William Thompson, GSFC, 28 March 1994
;			Incorporated into CDS library.
;		Version 2, William Thompson, GSFC/CDS (ARC), 1 June 1994
;			Added support for external (IEEE) representation.
;
; Version     :	Version 2, 1 June 1994
;-
;
;-----------------------------------------------------------------------
 On_error,2

 if N_params() LT 2 then begin
     print,'Syntax - dbrd, enum, entry, [available, dbno]'
     return
 endif

 COMMON db_com,qdb,qitems,qdbrec

; Find out if databases are in external format.

 external = db_info('EXTERNAL')

 if N_params() LT 4 then dbno = -1

 if dbno GE 0 then begin		;get only requeseted data base entry
	available = bytarr(1)+1b
    if dbno EQ 0 then begin
	entry = qdbrec(enum)
	if external(0) then db_ent2host, entry, 0
      end else begin
	len = db_info( 'LENGTH', dbno)
	unit = db_info( 'UNIT_DBF', dbno)
	p = assoc(unit,bytarr(len, /NOZERO), enum)
	entry = p(0)		;read entry
	if external(dbno) then db_ent2host, entry, dbno
    end
    return
 end

; get info on open data bases

 len = db_info( 'LENGTH' )	;record lengths
 units = db_info( 'UNIT_DBF' ) 	;unit numbers
 n = N_elements(len)		;number of db's opened
 entry = qdbrec(enum)		;read entry for first db
 if external(0) then db_ent2host, entry, 0
 irec = enum			;record number
 available = bytarr(n)+1B		;entry available

 if n GT 1 then begin
	for i = 1,n-1 do begin	;loop on db's
		pointer = db_info('pointer',i)		;what points to it
		db_item, pointer,itnum,ival,dtype,sb,nv,nb
		irec = dbxval(entry,dtype(0),1,sb(0),nb(0))
		if irec GT 0 then begin
			p = assoc( units(i), bytarr( len(i),/NOZERO ))
			tmp = p(irec)
			if external(i) then db_ent2host, tmp, i
			entry = [ entry, tmp ]	;add to end
		   end else begin
			available(i) = 0B
			entry = [ entry, bytarr(len(i))]
		end
	end
 end

 return
 end
