function dbtitle,c,f
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	DBTITLE()
; Purpose     :	
;	Function to create title line.  Subroutine of DBPRINT
; Explanation :	
;	Function to create title line for routine dbprint.
;	This is a subroutine of DBPRINT.
; Use         :	
;	result = dbtitle( c, f )
; Inputs      :	
;	c = string array of titles for each item
;	f = field length of each item
;
; Opt. Inputs :	None.
;
; Outputs     :	
;	header string returned as function value
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	
;	This is a subroutine of DBPRINT.
;
; Side effects:	None.
;
; Category    :	Utilities, Database.
;
; Prev. Hist. :	
;	version 1  D. Lindler  Sept 86
;
; Written     :	D. Lindler, GSFC/HRS, September 1986.
;
; Modified    :	Version 1, William Thompson, GSFC, 28 March 1994.
;			Incorporated into CDS library
;
; Version     :	Version 1, 28 March 1994.
;-
;
;------------------------------------------------------------
n=n_elements(c)
h=' '
com = strtrim(c,0)              ;header for item with trailing blanks removed
ncom = strlen(com)
for i=0,n-1 do begin		;loop on items
	flen=f(i)		;field length
	st=string(replicate(byte(32),flen+1));blank field
	ipos=((flen-ncom(i)+1)/2)>1	;starting position in field for comment
	strput,st,com(i),ipos	;insert into field
	h=h+st			;add to header
end; loop on items
return,h			;return header
end
