pro dbxput,val,entry,idltype,sbyte,nbytes
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	DBXPUT
; Purpose     :	
;	Routine to replace value of an item in a data base entry
; Explanation :	
;	Routine to replace value of an item in a data base entry
; Use         :	
;	dbxput, val, entry, idltype, sbyte, nbytes
; Inputs      :	
;	val - value(s) to be placed into entry, string values might be
;		truncated to fit number of allowed bytes in item
;	entry - entry to be updated
;	idltype - idl data type for item
;	sbyte - starting byte in record
;	nbytes - total number of bytes in value added
;
; Opt. Inputs :	None.
;
; Outputs     :	
;	entry - (updated)
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	
;	This routine assumes that the calling procedure or user
;	knows what he or she is doing.  No validity checks are made
;
; Side effects:	None.
;
; Category    :	Utilities, Database.
;
; Prev. Hist. :	
;	version 1, D. Lindler   Aug, 1986
;	converted to IDL Version 2.  M. Greason, STX, June 1990.
;
; Written     :	D. Lindler, GSFC/HRS, August 1986
;
; Modified    :	Version 1, William Thompson, GSFC, 28 March 1994
;			Incorporated into CDS library
;
; Version     :	Version 1, 28 March 1994
;-
;
;-------------------------------------------------------
;
case idltype of		;case of data type

   7: begin			;string
    	entry(sbyte) = replicate( 32b, nbytes)	; blank
	if strlen(val(0)) GT nbytes then val=strmid(val(0),0,nbytes)
	entry(sbyte) = byte(val)
      end
   1: entry(sbyte)=val
   else: entry(sbyte) = byte(val,0,nbytes)

endcase
return
end
