function dbxval,entry,idltype,nvalues,sbyte,nbytes
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	DBXVAL()
; Purpose     :	
;	Quickly return a value of the specified item number
; Explanation :	
;	Procedure to quickly return a value of the specified item number
;	from the entry.
;
; Use         :	
;	result = dbxval( entry, idltype, nvalues, sbyte, nbytes )
;
; Inputs      :	
;	entry - entry from data base (bytarr)
;	idltype - idl data type (obtained with db_item_info)
;	nvalues - number of values to return (obtained with db_item)
;	sbyte - starting byte in the entry (obtained with db_item)
;	nbytes - number of bytes (needed only for string type)
;			(obtained with db_item)
;
; Opt. Inputs :	None.
;
; Outputs     :	
;	function value is value of the specified item in entry
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	
;	To increase speed the routine assumes that entry and item are
;	valid and that the data base is already opened using dbopen.
;
; Side effects:	None.
;
; Category    :	Utilities, Database.
;
; Prev. Hist. :	
;	version 2  D. Lindler Nov. 1987  (for new db format)
;
; Written     :	D. Lindler, GSFC/HRS, November 1987.
;
; Modified    :	Version 1, William Thompson, GSFC, 28 March 1994.
;			Incorporated into CDS library.
;
; Version     :	Version 1, 28 March 1994.
;-
;
;----------------------------------------------------------------
;
case idltype of 		;case of data type
  1: val = byte(entry,sbyte,nvalues)
  2: val = fix(entry,sbyte,nvalues)
  3: val = long(entry,sbyte,nvalues)
  4: val = float(entry,sbyte,nvalues)
  5: val = double(entry,sbyte,nvalues)
  7: val = string( entry(sbyte:sbyte+nbytes-1))
endcase
;
if ( nvalues EQ 1 ) then return,val(0) else return,val
end
