pro get_date,dte
;+
; Project     : SOHO - CDS
;
; Name        : 
;	GET_DATE
; Purpose     : 
;	Gets date in format used by FITS headers.
; Explanation : 
;	Return the current date in DD/MM/YY format.  This is the format
;	required by the DATE and DATE-OBS keywords in a FITS header
; Use         : 
;	GET_DATE, dte
;
;	Add the current date to the DATE keyword in a FITS header,h
;
;		GET_DATE,dte
;		sxaddpar,h,'DATE',dte
;
; Inputs      : 
;	None
; Opt. Inputs : 
;	None.
; Outputs     : 
;   dte = An eight character scalar string specifying the current day (0-31),
;         current month (1-12), and last two digits of the current year
; Opt. Outputs: 
;	None.
; Keywords    : 
;	None.
; Calls       : 
;	None.
; Common      : 
;	None.
; Restrictions: 
;	None.
; Side effects: 
;	None.
; Category    : 
;	Data Handling, I/O, FITS, Generic.
; Prev. Hist. : 
;	Written      W. Landsman          March 1991
; Written     : 
;	Wayne Landsman, GSFC/UIT, March 1991.
; Modified    : 
;	Version 1, William Thompson, GSFC, 12 April 1993.
;		Incorporated into CDS library.
; Version     : 
;	Version 1, 12 April 1993.
;-
;
 On_error,2

 if N_params() LT 1 then begin
     print,'Syntax - Get_date, dte'
     print,'  dte - 8 character output string giving current date'
     return
 endif

 mn = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct', $
       'Nov','Dec']

 st = !STIME
 day = strmid(st,0,2)
 month = strmid(st,3,3)
 month = where(mn EQ month) + 1
 yr = strmid(st,9,2)

 dte =  string(day,f='(I2.2)') + '/' + string(month,f='(i2.2)') + '/' + yr
 
 return
 end
