pro hprint, h, firstline
;+
; Project     : SOHO - CDS
;
; Name        : 
;	HPRINT
; Purpose     : 
;	Prints FITS headers on terminal screen.
; Explanation : 
;	Print a FITS header (or any other string array) at the the terminal
;	by printing 1 line at a time.
;	Needed because IDL Version 2 will add an extra space to the 80
;	character FITS lines, causing a space to appear betweeen lines.
; Use         : 
;	HPRINT, H
; Inputs      : 
;	H - FITS header (or any other string array).
; Opt. Inputs : 
;	None.
; Outputs     : 
;	None.
; Opt. Outputs: 
;	None.
; Keywords    : 
;	None.
; Calls       : 
;	None.
; Common      : 
;	None.
; Restrictions: 
;	None.
; Side effects: 
;	HPRINT has the following differences from the intrinsic PRINT procedure
;
;   (1) Arrays are printed one line at a time to avoid a space between 80
;       character lines
;   (2) Lines are trimmed with STRTRIM before being printed to speed up display
;   (3) The /more option is used for output. 
;   (4) This version only works in Version 2.1.* or later.
;
; Category    : 
;	Data Handling, I/O, FITS, Generic.
; Prev. Hist. : 
;	Written W. Landsman             July, 1990
;	Added test for user quit       July, 1991
;	Added optional FIRSTLINE arguement      November, 1992
;	Modifed for Mac IDL, I  Freedman HSTX April 1994        
; Written     : 
;	Wayne Landsman, GSFC/UIT, July 1990.
; Modified    : 
;	Version 1, William Thompson, GSFC, 12 April 1993.
;		Incorporated into CDS library.
;	Version 2, William Thompson, GSFC, 26 October 1994
;		Brought up-to-date with idlastro version.
; Version     : 
;	Version 2, 26 October 1994
;-
;
  On_error,2                        ;Return to Caller

  if N_params() EQ 0 then begin
       print,'Syntax - HPRINT, h, [ firstline ]'
       return
  endif

  n = N_elements(h)
  if ( n EQ 0 ) then    $               ;Make sure input array is defined
     message,'String array (first parameter) not defined'
  if !VERSION.OS NE 'MacOS' then begin
   openw, outunit, filepath(/TERMINAL), /MORE, /GET_LUN    ;Open with /more
  endif else begin
   outunit = -1
  endelse

  if N_elements( firstline ) EQ 0 then firstline = 1
  if ( firstline(0) LT 0 ) then firstline = ( n + firstline(0)) > 1 < n  $
				else firstline = firstline(0) > 1 < n

; Now print the array one line at a time

  for i = firstline-1, n-1 do begin

     printf, outunit, strtrim( h(i) )               
     if !ERR EQ 1 then goto, DONE      ;User entered "Q" in response to /more

  endfor

DONE:  if !VERSION.OS NE 'MacOS' then free_lun, outunit

  return
  end

