;+
; Project     : SOHO - CDS     
;                   
; Name        : PSTORE()
;               
; Purpose     : Store Plot Region data (!P,!X,!Y,!D, and data X/Y size)
;               
; Explanation : Pstore is used to store information about plot regions
;		where data is displayed (plotted or TV'ed). 
;		The !P/!X/!Y/!D system variables should be set by
;		the caller by e.g. plotting with x/yrange set
;		to the correct values, with x/ystyle=1.
;
;		More than one plot region per window can be used,
;		just supply a unique NUMBER for each plot. If the
;		plot is redisplayed later, an identical call to
;		PSTORE will store the information on the same plot
;		region ID number as the previous one.
;
;		For TV'ed data, note that the correct ranges for the
;		axes are [coordinate of leftmost pixel - 1/2 *stepsize,
;			  coordinate of rightmost ""   + 1/2 *stepsize]
;		For plotted data (i.e., plot,x,y), xrange should
;		not be expanded in this way (the first and last data
;		points will fall _on_ the border of the plot region).
; 
;               Equidistant scales are assumed. 
;
; Use         : plot_region_no = PSTORE(NUMBER,XSIZE,YSIZE)
;    
; Inputs      : NUMBER : A user-assigned number identifying the
;			plot region(s) within this window.
;
;		X/YSIZE: The size of the displayed data. For 1D data,
;			use XSIZE=number of points, and YSIZE=1.
;               
; Opt. Inputs : None.
;               
; Outputs     : Return value: A Plot Region ID, referring to
;			the stored plot region.
;               
; Opt. Outputs: None.
;               
; Keywords    : CLEAN : Set to remove any earlier plot region definitions
;			for this window.
;
;		INIT : Restarts the common block.
;
; Calls       : None.
;
; Common      : WSTORE
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Utility, Graphics
;               
; Prev. Hist. : None.
;
; Written     : Stein Vidar Hagfors Haugan, May 1994
;               
; Modified    : 
;
; Version     : 1, May 1994
;-            

;
; DATAX,DATAY = Image size, in data pixels
; Screen size is taken from !P.clip
;

FUNCTION pstore,NN,datax,datay,clean=clean,init=init
  common wstore,D,P,N,X,Y,dataxx,datayy
  
  
  IF Keyword_SET(clean)	and N_elements(D) gt 0 THEN BEGIN
      ix = where(D(*).NAME eq !D.NAME and D(*).WINDOW eq !D.window,count)
      IF count gt 0 THEN D(ix).window =	-1
      IF n_params() lt 1 THEN return,-1
  EndIF
  
  IF N_params()	lt 1 THEN message,'Needs number of the plot region'
  
  IF N_params()	lt 3 THEN BEGIN
      IF N_elements(datax) eq 0	THEN datax=1
      IF N_elements(datay) eq 0	THEN datay=1
  EndIF
  
  
  IF N_elements(D) gt 0	and NOT	Keyword_SET(init) THEN BEGIN
      
      ix = where(D(*).NAME eq !D.NAME and D(*).WINDOW eq !D.window $
		 and N(*) eq NN, count)
      
      IF count gt 1 THEN message,'Double window ????'
      
      IF count gt 0 THEN BEGIN
	  D(ix)	= !D   &  P(ix)	= !P  &	N(ix) =	NN
	  X(ix)	= !X   &  Y(ix)	= !Y
	  dataxx(ix)=datax   & datayy(ix)=datay
	  i = ix(0)
      END ELSE BEGIN
	  D = [D,!D]	 & P = [P,!P]  & N = [N,NN]
	  X = [X,!X]	 & Y = [Y,!Y]
	  dataxx = [dataxx,datax] & datayy = [datayy,datay]
	  i = N_elements(D)-1
      END
  END ELSE BEGIN
      D	= [!D]	 &  P =	[!P]   &   N = [NN]
      X	= [!X]	 &  Y =	[!Y]
      dataxx = [datax] &  datayy	= [datay]
      i	= 0
  EndELSE
  
  return,i
  
END



