;+
; Project     : SOHO - CDS     
;                   
; Name        : TICK_VEC
;               
; Purpose     : Generate tickmarks for tight displays.
;               
; Explanation : Up to a specified number of equidistant tickmarks are returned.
;               
; Use         : TICVEC = TICK_VEC(MAXN,MIN,MAX)
;    
; Inputs      : MAXN : The maximum number of tick marks allowed.
;               MIN  : The minimum value on the axis
;		MAX  : The maximum value on the axis
; Opt. Inputs : None.
;               
; Outputs     : Returns a vector in the interval [ MIN, MAX ], with up to MAXN entries.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : None.
;
; Common      : None.
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Utilities, Graphics
;               
; Prev. Hist. : None.
;
; Written     : Stein Vidar Haugan, June 1994
;               
; Modified    : Never.
;
; Version     : 1, 9 June 1994
;-            



FUNCTION tick_vec,MaxN,min,max
  
  min =	double(min)
  max =	double(max)
  
  diffmagn = alog10(abs(max-min))
  
  f = fix(diffmagn) - 1
  
  relmax = max/(10.d^f)
  relmin = min/(10.d^f)
  
  relspan = abs(relmax-relmin)
  IF relspan lt	4.0d THEN BEGIN
      f	= f - 1
      relspan =	relspan*10.d
      relmax = relmax*10.d
      relmin = relmin*10.d
  EndIF
  
  relspan = relspan
  
  divfact = fix(relspan/MaxN) >	1
  
  N = fix(0.5+relspan/divfact+0.2)
  
  vect = (findgen(N)*divfact + fix(relmin+1.0d))*10.0d^f
  return,vect
END

PRO testvec
  
  vec =	tick_vec(5,10.1456,15.)
  
END
