;+
; NAME:
;       x2gif
; PURPOSE:
;      read and write X window to gif file
; CALLING SEQUENCE:
;      x2gif,file
; INPUTS:
;      file = gif file name
; OPTIONAL INPUTS:
;      r,g,b = color table values
; OPTIONAL KEYWORDS:
;      windex = index of window to be plotted
;      xsize,ysize = window size to select [def = whole window]
;      title = title for GIF file
;      xpos,ypos = position of title
;      psize = extra keywords for xyouts
; MODIFICATION HISTORY:     
;      DMZ (ARC) Jul'94
;-
 
pro x2gif,file,r,g,b,windex=windex,xsize=xsize,ysize=ysize,title=title,$
               _extra=psize,xpos=xpos,ypos=ypos

on_error,1

if n_elements(file) eq 0 then begin
 file='idl.gif'
 message,'GIF file saved in '+file,/cont
endif

if ((n_elements(windex) eq 0) and (!d.window eq -1)) or (!d.name ne 'X') then $
 message,'NO WINDOW ACTIVE'

if n_elements(windex) ne 0 then begin
 if windex gt -1 then wset,windex
endif
 
;-- read window

if n_elements(xsize) eq 0 then xsize=!d.x_size
if n_elements(ysize) eq 0 then ysize=!d.y_size

;-- write title

if datatype(title) eq 'STR' then begin
 if n_elements(xpos) eq 0 then xpos=.1
 if n_elements(ypos) eq 0 then ypos=.9
 xyouts,xpos,ypos,title,_extra=psize,norm=1,size=1.5,charthick=1.5,font=-1
endif

a=tvrd(0,0,xsize,ysize)

if n_elements(r)*n_elements(g)*n_elements(b) eq 0 then cload=0 else cload=1

if cload then write_gif,file,a,r,g,b else write_gif,file,a


return & end
