;+
; Project     : SOHO - CDS     
;                   
; Name        : CDSLOC
;               
; Purpose     : Locate any file name in /cs tree with specified string.
;               
; Explanation : Issues a find command to locate any files in the /cs tree
;               whose names contain the given string. 
;               
; Use         : IDL> cdsloc, string [, result, /quiet]
;    
; Inputs      : string - any string to be searched for.
;               
; Opt. Inputs : None
;               
; Outputs     : result - string array containing full file name specification.
;               
; Opt. Outputs: None
;               
; Keywords    : quiet - if specified, result is not output to terminal.
;
; Calls       : None
;
; Common      : None
;               
; Restrictions: None
;               
; Side effects: None
;               
; Category    : Help
;               
; Prev. Hist. : None
;
; Written     : C D Pike, RAL, 21-Jun-94
;               
; Modified    : 
;
; Version     : Version 1, 21-Jun-94
;-            

pro cdsloc, str, result, quiet=quiet

;
;  set up general find command
;
command = "find /cs/ -name '*"+strtrim(str,2)+"*' -print"

;
;  issue it and save result
;
spawn,command,result

;
;  can't save and print spawn results to screen so do it manually
;
if not keyword_set(quiet) and result(0) ne '' then begin
   for i=0,n_elements(result)-1 do print,result(i)
endif

end
