;+
; Project     :	SOHO - CDS
;
; Name        :	RD_ASCII
;
; Purpose     : Read sequential ASCII file
;
; Explanation :
;
; Use         : output = rd_ascii(file)
;
; Inputs      : file = string file name
;
; Opt. Inputs : None.
;
; Outputs     : output = string array with ASCII text
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : FSTAT
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : I/O
;
; Prev. Hist. : None.
;
; Written     :	Version 1.0, DMZ (ARC) August 22 1994
;
; Modified    : Version 1.1, DMZ (ARC/GSFC) October 29 1994
;               Fixed potential bug in irec
;
; Version     : 1.1 
;
;-

FUNCTION rd_ascii,file

   line = ' '
   lines = STRARR(10)

   OPENR, lun, file, /GET_LUN
   fstat = fstat(lun)
   irec = -1
   WHILE fstat.cur_ptr LT fstat.size DO BEGIN
      irec = irec + 1
      IF (irec MOD 10) EQ 0 THEN lines = [lines,STRARR(10)]
      READF, lun, line
      if (irec gt -1) and (irec lt n_elements(lines)) then $
       lines(irec) = line
      fstat = fstat(lun)
   ENDWHILE

   FREE_LUN, lun

   if (irec gt -1) and (irec lt n_elements(lines)) then $
    lines = lines(0:irec) else lines=''
   RETURN,lines 
END

