;+
; Project     : SDAC
;
; Name        : 
;	SCANPATH
; Purpose     : 
;	Widget prog. for reading documentation within IDL procedures
; Explanation : 
;	Widget-based routine to read in the documentation from IDL procedures
;	in the search path.  Optionally, reads in the entire procedure.
; Use         : 
;	SCANPATH  [, NAME ]
; Inputs      : 
;	None required.
; Opt. Inputs : 
;       NAME:           Name of procedure to search and document
; Outputs     : 
;	None.
; Opt. Outputs: 
;       PROC:           String array with the text of the latest saved procedure
; Keywords    : 
;       RESET:          Clear out previous procedures from memory
;	FONT:     	Optional font to use in the base widget.  Note that the
;			font is a function of the computer or terminal
;			providing the X-windows display server, not the host
;			computer for the IDL application.
;       NOSPLIT:        If set, then do not split procedure text base into 
;                       a separate base
;       PC:             If set, then put directory list widget in separate column
;       LAST:           Restore last procedure in memory
;                       
; Buttons     : 
;	QUIT:		Exits SCANPATH.
;	PRINT:		Prints selected procedure.
;	DOC ONLY / ALL:	Toggles between showing only the documentation from a
;			file (the part between the "+" and "-" lines), and
;			the entire file.
;       EXTRACT         Extract and copy procedure from library and/or directory
;                       to current working directory with ".txt" extension.
; Env. Vars.  : 
;	IDL_PRINT_TEXT:	Environment variable (VMS: logical name) which contains
;			the print command to be used in printing files.
;	XDOC_FONT:	Optional font to use in the text widget.  Note that the
;			font is a function of the computer or terminal
;			providing the X-windows display server, not the host
;			computer for the IDL application.
;       XDOC_ONLY       If set to 1, then make DOC only the default
;
; Calls       : 
;	CONCAT_DIR, GET_LIB, GET_MOD, GET_PROC, LOC_FILE
; Common      : 
;	Uses the common blocks defined in SP_COMMON.
; Restrictions: 
;	Needs X-windows and widgets support (MOTIF or OPENLOOK).
; Side effects: 
;	If "ALL" is selected to read in the entire file, then memory problems
;	may arise when reading very large procedure files.
; Category    : 
;	Documentation, Online_help.
; Prev. Hist. : 
;	Written May'91 by DMZ (ARC).
;	Modified Dec 91 by WTT (ARC) to support UNIX, and add the following
;		features:
;			- Search current directory, as well as !PATH
;			- Allow for files "aaareadme.txt" containing more
;			  general information to also be searched.
;			- Only save last five procedures in memory.
;			- Add "documentation only" button.
;			- Use environment variable IDL_PRINT_TEXT
;			- Change extensions ".SCL", ".MOD" to "._SCL", "._MOD".
;       Modified Jan'92 by DMZ (ARC) to sense screen size and autosize widgets
;	Modified Feb'92 by WTT (ARC) to use SCANPATH_FONT environment variable.
;	Modified Feb'92 by DMZ (ARC) to include a message window
;	Modified Mar'92 by DMZ (ARC) to enable remote printing of files
;       Modified Jul'92 by DMZ (ARC) to improve DOC_ONLY switch and add EXTRACT button
;       Modified Oct'92 by DMZ (ARC) to accept procedure name as input
;       Modified Dec'92 by EEE (HSTX) to accept search strings
;       Modified Mar'93 by DMZ (ARC) to handle "~" in UNIX directory names
;                                    and print modules from VMS text libraries
; Written     : 
;	D. Zarro, GSFC/SDAC, May 1991.
; Modified    : 
;	Version 1, William Thompson, GSFC, 23 April 1993.
;		Renamed SCANPATH_COM to SP_COMMON for DOS compatibility,
;		changed line defining YSZ, and incorporated into CDS library.
;	Version 2, William Thompson, GSFC, 18 June 1993.
;		Added IDL for Windows compatibility.
;		Changed size of widgets to better fit in IDL for Windows.
;		Split columns into two widget windows to make better use of
;               space.
;	Version 2.1 Dominic Zarro, GSFC, 21 July 1993.
;		Made procedure and search text widgets independent bases.
;       Version 3, Dominic Zarro, GSFC, 1 August 1994.
;               Cleaned up and added check for XDOC_ONLY environment variable.
;               Changed SCANPATH_FONT to XDOC_FONT for procedure text widget
;       Version 3.1, Dominic Zarro, GSFC, 16 August 1994.
;               Added /NOSPLIT keyword.
;               Fixed /FONT so that original font is restored on exit.
;               (This keyword overrides the value of XDOC_FONT)
;       Version 3.2, Zarro, GSFC, 24 August 1994.
;               Fixed bug where XMANAGER was being called twice.
;               Excised PC keyword
;       Version 3.3, Zarro, GSFC, 3 September 1994.
;               Fixed another potential bug when XMANAGER was being
;               called twice during search. 
;       Version 4, Zarro, GSFC, 18 September 1994.
;               Put back /PC. If set, then the directory list widget appears
;               in a second column (rather than in a third row, where
;               it usually falls off the screen). 
;       Version 4.1, Zarro, GSFC, 19 September 1994.
;               Removed forcing of procedure names to lowercase.
;               Converted PROC keyword to argument to enable transfer
;               back to XDOC
;       Version 5, Zarro, GSFC, 10 October 1994.
;               Changed search text function to search file function.
;               Added STRIP_DOC function.
;       Version 5.1, Zarro, GSFC, 22 October 1994.
;               Added LAST keyword to restore last save procedure
;       Version 5.2, Zarro, GSFC, 12 December 1994.
;               Fixed potential bug in FIND logic -- should only arise
;               in 1 in 22 million cases.
;  Version:
;	Version 5.2, 12 December 1994.
;-
;
;
;============================================================================

pro find_proc,name,found=found       ;-- find files in !path

@sp_common

widget_control,comment,set_value='Searching for file, standby...'
widget_control,base,sensitive=0
chkarg,name,proc,tname,found=found
break_file,name,dsk,dname,pname,ext,vers

widget_control,base,sensitive=1

;-- if found then list it (prepend "@" back onto library name).

if found then begin
 lname=tname
 fname=strtrim(pname+ext+vers,2)
 last_name=fname
 tlb=strpos(strlowcase(tname),'.tlb') gt -1
 mods=get_mod(lname)
 readme=(strpos(strlowcase(fname),'aaareadme.txt') gt -1)
 widget_control,mlist,set_value=mods,set_uvalue='m_'+mods
 if doc_only and not readme then tproc=strip_doc(proc) else tproc=proc
 if (widget_info(base2,/realize) eq 0) then begin
  widget_control,base2,/realize,tlb_set_xoffset=woff(0)+wsize(0)/2.,/show
 endif else widget_control,base2,/show
 widget_control,ftext,set_value=tproc
 if search and (widget_info(sear,/realize) ne 0) then widget_control,sear,/show,/map
 widget_control,comment,set_value=name+' found in:'
 widget_control,comment,set_value=lname,/append
 widget_control,flabel,set_value=fname

;-- highlight list widgets

 lrev=string(reverse(byte(lname)))
 chk=strpos(lrev,'/')
 tname=lname
 if chk eq 0 then tname=string(reverse(byte(strmid(lrev,1,strlen(lrev)))))
 if vms then clook=where(strupcase(tname) eq strupcase(lnames),cnt) else $
  clook=where(tname eq lnames,cnt)
 if cnt gt 0 then widget_control,tlist,set_list_select=clook(0)

 break_file,name,dsk,hname,tname,ext
 if (ext eq '') and (not tlb) then tname=tname+'.pro'
 if vms then clook=where(strupcase(tname) eq strupcase(mods),cnt) else $
  clook=where(tname eq mods,cnt)
 if cnt gt 0 then widget_control,mlist,set_list_select=clook(0)

endif else widget_control,comment,set_value=name+' not found'

return & end

;============================================================================

pro scanpath_event, event                         ;event driver routine

@sp_common

;-- take care of different event names

widget_control, event.id, get_uvalue = uservalue
if (n_elements(uservalue) eq 0) then uservalue=''

;-- check in case user killed widgets using window manager
;   "close" button

if widget_info(base2,/valid) eq 0 then begin
 base2=widget_base(title=' ',space=fspace,xpad=fxpad,ypad=fypad,/column)
 temp=widget_base(base2,/column,space=fspace,xpad=fxpad,ypad=fypad)   
 flabel=widget_label(temp,value=' ',xsize=txsize,ysize=2,/frame,font=dfont)
 ftext=widget_text(temp,xsize=txsize,ysize=tysize,/scroll,font=dfont) 
endif

if widget_info(sear,/valid) eq 0 then begin
 sear = widget_base(title=' ',/column,/frame,map=0,space=fspace,xpad=fxpad,ypad=fypad)   
 cur_sear = widget_label(sear, value='Current search file is : ',  $
				font=dfont)
 newtext = widget_label(sear, value='Enter file name to search for and return',font=dfont)
 entval = widget_text(sear, /editable, ysize=1,xsize=50,/frame,font=dfont)
endif

;-- take care of button widgets

wtype=widget_info(event.id,/type)

if wtype eq  1 then begin
 bname=strtrim(uservalue,2)

;-- temporarily save text in home directory 

 if (bname eq 'print') or (bname eq 'extract') then begin
  openw,lun,dumpfile,/get_lun
  for i=0,n_elements(tproc)-1 do printf,lun,tproc(i)
  close,lun & free_lun,lun
 endif

 case bname of 

  'quit'   :         begin            ;-- delete temporary files
                      if vms then begin
                       look=findfile('sys$login:*._sdac_*;*',count=nf)
                       if nf gt 0 then begin
                        for i=0,nf-1 do begin
                         spawn,'delete/nolog/noconfirm '+look(i)
                        endfor
                       endif
		      endif else if !version.os eq 'windows' then begin
		       look=findfile(dumpfile,count=nf)
		       if nf gt 0 then spawn,'delete '+dumpfile
                      endif else begin
                       dcls=loc_file(dumpfile,count=dc)
                       if dc ne 0 then spawn,'rm -f '+dumpfile
                      endelse

                      if (chklog('XDOC_CLEANUP') ne '') and $
                         (widget_info(base2,/valid) ne 0) then $
                       widget_control,/destroy,base2,bad_id=destro,/clear
                      widget_control,base,/destroy,/clear_events,bad_id=destroyed
                     end

  'print'  :         begin                         ;-- print file
                      m='Printing '+fname
                      widget_control,comment,set_value=m
                      printc=printcom+' '+dumpfile
                      if vms then begin
                       dc=strpos(lname,'::')      ;-- for remote printing
                       if (dc gt -1) then printc=printc+' /remote'
                      endif 
                      message,printc,/contin
                      spawn,printc
                      widget_control,comment,set_value='Ready for another selection'
                      return
                     end

  'extract':         begin                        ;-- extract file
                      cd,cur=def
                      m='Extracting '+fname+' into '+def
                      widget_control,comment,set_value=m
                      if fname eq '*info*' then tname='aaareadme' else begin
                       ext=strpos(fname,'.pro')
                       if ext gt -1 then tname=strmid(fname,0,ext) else tname=fname
                      endelse
                      target=concat_dir(def,tname+'.txt')
                      if vms then begin
			cp = 'copy/log/noconfirm '
		      endif else if !version.os eq 'windows' then begin
			cp = 'copy '
		      endif else begin
			cp='cp'
		      endelse
                      spawn,cp+' '+dumpfile+' '+target
                      return
                     end

  else:              begin
		      case bname of 
			  'doc_only'  : doc_only=1 
			  'all'      : doc_only=0
			  'search'   : search=1
			  'nosearch' : search=0
		      endcase

                      if (bname eq 'doc_only') or (bname eq 'all') then begin
                       if fname ne '' then begin
                        prefix='m_' & suffix=fname & goto,again
                       endif
                       return
                      endif

                      sabre=(widget_info(sear,/realize) ne 0)
                      if search then begin
                       widget_control,comment,$ 
                        set_value='Please type file name to search for'
                       if not sabre then begin
                        widget_control,sear,/realize,$
                         tlb_set_xoffset=woff(0)+wsize(0)/2,$
                         tlb_set_yoffset=woff(1)+wsize(1)/2,/show,/map
                         xmanager,'scanpath',sear,group_leader=base
                       endif else begin
                        widget_control,sear,/show,/map
                       endelse
                      endif else begin
                       if sabre then widget_control,sear,map=0
                      endelse
                     end
 endcase
endif

;-- list events

if wtype eq 6 then begin
 search=0
 if widget_info(sear,/realize) ne 0 then widget_control,sear,map=0
 widget_control,searb(0),set_button=1
 widget_control,searb(1),set_button=0

 ename=uservalue(event.index) 
 prefix=strmid(ename,0,2) & len=strlen(ename)
 suffix=strmid(ename,2,len)
again:
 case prefix of

  'l_':    begin                    ;--  determine module names 
            lname=suffix
            widget_control,comment,$
             set_value='Getting procedure names, standby...'
	    mods=get_mod(lname(0))
            widget_control,base,/show
            if n_elements(mods) eq 0 then mods=''
            if (n_elements(mods) eq 1) and (strtrim(mods(0),2) eq '') then begin
             widget_control,mlist,set_value=mods
             widget_control,mlist,sensitive=0,/show
             widget_control,comment,set_value='No procedures found'
             return
            endif else begin
             widget_control,mlist,/sensitive,/show
             widget_control,mlist,set_value=mods,set_uvalue='m_'+mods
             widget_control,comment,set_value='Please select a procedure'
             return
            endelse
           end

   'm_':   begin
            fname=suffix
            widget_control,comment,$
             set_value='Reading '+fname+', standby...'
            widget_control,flabel,set_value='      '
            widget_control,ftext,set_value=''
	    proc=get_proc(lname(0),fname)
            readme=(strpos(strlowcase(fname),'*info*') gt -1)
            if doc_only and not readme then tproc=strip_doc(proc) else tproc=proc
            last_name=fname
            widget_control,base,/show
            if (widget_info(base2,/realize) eq 0) then begin
             widget_control,base2,/realize,$
              tlb_set_xoffset=woff(0)+wsize(0)/2.,/show
            endif else widget_control,base2,/show
            if n_elements(proc) ne 0 then begin
             widget_control,flabel,set_value=fname
             widget_control,ftext,set_value=tproc,/show
            endif
            if search and (widget_info(sear,/realize) ne 0) then widget_control,sear,/show
            widget_control,comment,set_value='Ready for another selection'
            return
           end
   else:   return
 endcase
endif

;-- search for file

if wtype eq  3 then begin
 widget_control, entval, get_value=value, set_value=''
 name = value(0)
 maxb=50
 if strlen(name) lt maxb then ellipse='' else ellipse='...' 

 widget_control, cur_sear, set_value='Current search file is : ' + $
				strmid(name,0,maxb-1) + ellipse
 if name ne '' then find_proc,name,found=found
endif

return & end

;============================================================================

pro scanpath,name,proc,just_reg=just_reg,reset=reset,font=font,last=last,$
                  group_leader=group_leader,nosplit=nosplit,pc=pc

@sp_common

if not have_widgets() then message,'widgets are unavailable'
if n_elements(procs) eq 0 then procs=''
if n_elements(names) eq 0 then names=''
vms=!version.os eq 'vms'

if keyword_set(nosplit) then split=0 else split=1
if keyword_set(pc) then pc=1 else pc=0
if pc then split=1

;-- load optimum font into base widget (once only)

pfont=chklog('xdoc_font')
if pfont eq '' then pfont=chklog(strupcase('xdoc_font'))
dfont=pfont
if keyword_set(font) then begin
 dfont=get_dfont(font)
 dfont=dfont(0)
 if (dfont ne '') then begin
  message,'using font '+dfont,/contin
 endif
endif

;-- device dependent stuff


printcom = chklog('idl_print_text')
if printcom eq '' then printcom=chklog(strupcase('idl_print_text'))
if printcom eq "" then begin
 case !version.os of
  'vms' :     printcom = "print"
  'windows':  printcom = "print"
   else:      printcom = "lpr"
 endcase
endif
dfile='scanpath._sdac_dmp'
if vms then begin
	dumpfile = 'sys$login:'+dfile
end else if !version.os eq 'windows' then begin
	dumpfile = 'c:\'+dfile
end else begin
	dumpfile='~/'+dfile
endelse

;-- wipe memory clean

fname=''
if n_elements(last_name) eq 0 then last_name=''
if keyword_set(reset) then begin
 names='' & procs='' & last_name=''
endif

if (not keyword_set(group_leader)) and (not keyword_set(just_reg)) then begin
 if keyword_set(reset) then widget_control,/reset,/clear_ev,bad_id=destroy else begin
  if n_elements(base) ne 0 then begin
   if widget_info(long(base),/valid) then widget_control,base,/destroy,/clear_ev,bad_id=destroy
  endif
  if n_elements(base2) ne 0 then begin
   if widget_info(long(base2),/valid) then widget_control,base2,/destroy,/clear_ev,bad_id=destroy
  endif
 endelse
endif else begin
 if xregistered('scanpath') then begin
  message,'already registered',/contin
  xmanager
 endif
endelse

;-- autosize screen

get_screen,fspace,fxpad,fypad,scx,scy


base = widget_base(title ='XDOC Version 5', xpad = fxpad, ypad = fypad,$
                   space = fspace, /row)

;-- top row of buttons

col1=widget_base(base,title=' ',space=fspace,xpad=fxpad,ypad=fypad,/column)   
temp=widget_base(col1,/row,space=fspace,/frame,xpad=fxpad,ypad=fypad)   

;-- return button

quitb=widget_button(temp,value='Quit',uvalue='quit',/no_release,/frame,$
      font=dfont)

bopts=widget_base(temp,/row,space=fspace,xpad=fxpad,ypad=fypad)   

;-- print button

printb=widget_button(bopts,value='Print',uvalue='print',/no_release,font=dfont)

;-- extract button

extractb=widget_button(bopts,value='Extract',uvalue='extract',/no_release,$
         font=dfont)

;-- doc only button

values=['All','Doc Only']
xmenu,values,bopts,/column,/exclusive,/frame,/no_release,space=fspace,xpad=fxpad,ypad=fypad,$
      buttons=docb,uvalue=['all','doc_only'],font=dfont

doc_only=(chklog('XDOC_ONLY') eq '1')
search=0
widget_control,docb(doc_only),set_button=1

choices = ['No Find ','Find']
xmenu,choices,bopts,/column,/exclusive,/frame,space=fspace,/no_release,$
		xpad=fxpad,ypad=fypad,buttons=searb,$
                uvalue=['nosearch','search'],font=dfont

widget_control,searb(search),set_button=1


;-- 1st column contains list of libraries (or directories) and modules

comment=widget_text(col1,ysize=2,value=' ',/scroll,font=dfont)
temp=widget_base(col1,/column,space=fspace,xpad=fxpad,ypad=fypad,/frame)   
lnames=get_lib()
tlabel=widget_label(temp,font=dfont,$
                    value='Select from the following directories/libraries')
tlist=widget_list(temp,ysize=12,value=lnames,uvalue='l_'+lnames,font=dfont)

;-- list of modules in selected library

if pc then begin
 temp=widget_base(base,/column,space=fspace,xpad=fxpad,ypad=fypad,/frame)   
endif else begin
 temp=widget_base(col1,/column,space=fspace,xpad=fxpad,ypad=fypad,/frame)   
endelse

mlabel=widget_label(temp,value='Select from the following procedures',font=dfont)
mlist=widget_list(temp,ysize=12,font=dfont)

;-- search widget

text=''
if strlen(text) lt 10 then ellipse='' else ellipse='...' 

sear = widget_base(title=' ',/column,/frame,space=fspace,xpad=fxpad,ypad=fypad)   
cur_sear = widget_label(sear, value='Current search file is : ' + $
				strmid(text,0,9) + ellipse,font=dfont)
newtext = widget_label(sear, value='Enter file name to search for and return',font=dfont)
entval = widget_text(sear, /editable, ysize=1,xsize=50,/frame,font=dfont)

;-- 2nd column will contain text of selected procedure (separate base in windows)

if split then begin
 base2=widget_base(title=' ',space=fspace,xpad=fxpad,ypad=fypad,/column)
endif else begin
 base2=widget_base(base,title=' ',space=fspace,xpad=fxpad,ypad=fypad,/column)
endelse

;-- procedure window

if pc then begin
 txsize=50 & tysize=20
endif else begin
 txsize=80 & tysize=40
endelse
temp=widget_base(base2,/column,space=fspace,xpad=fxpad,ypad=fypad)   
flabel=widget_label(temp,value=' ',xsize=txsize,ysize=2,/frame,font=dfont)
ftext=widget_text(temp,xsize=txsize,ysize=tysize,/scroll,font=dfont) 

;-- create and position windows

widget_control,base,/realize
widget_control,base,tlb_get_size=wsize,tlb_get_offset=woff

;-- check input

found=0

if datatype(name) ne 'STR' then name=''
if keyword_set(last) and (last_name ne '') and (name eq '') then name=last_name
 
if name ne '' then begin
 find_proc,name,found=found
 if found then widget_control,base2,/show,/realize,$
               tlb_set_xoffset=woff(0)+wsize(0)/2.
endif else widget_control,comment,set_value='Please select a library/directory'

xmanager,'scanpath',base,just_reg=just_reg

;-- return most recent procedure

if not keyword_set(just_reg) then begin
 xmanager
 if n_elements(tproc) ne 0 then proc=tproc
endif

return & end


