;+
; Name        : STRIP_ARG
;
; Purpose     : Strip argument and keyword calls from an IDL program.
;
; Explanation : 
;
; Use         : STRIP_ARG,PROC
;
; Inputs      : 
;	        PROC = string array with text of program.
;
; Outputs     : 
;	        None.
;
; Category    : Documentation, Online_help.
;
; Written     : Dominic Zarro, ARC, 10 October 1994.
;
;-

pro strip_arg,proc

on_error,1           

if datatype(proc) ne 'STR' then message,'input must be string array'

;-- read source code and search for call line identified by PRO or FUNCTION

valid=0 & nlines=n_elements(proc)

;-- strip off comment lines and blanks

tproc=strtrim(proc,2)
ok=where( (tproc ne '') and (strpos(tproc,';') ne 0),nlines)
if nlines gt 0 then begin
 tproc=tproc(ok)
 for i=0,nlines-1 do begin
  line=strcompress(tproc(i))
  procd=strpos(strupcase(line),'PRO ')
  func=strpos(strupcase(line),'FUNCTION ')
  pfound=((procd eq 0) or (func eq 0))
  if pfound then begin  
   valid=1
   semi=strpos(line,';')
   if semi gt 0 then line=strmid(line,0,semi)
   print,'---> Call: ',line
   repeat begin
    doll=strpos(line,'$')
    contin=(doll gt -1) 
    if contin then begin
     i=i+1
     line=tproc(i)
     semi=strpos(line,';')
     if semi gt 0 then line=strmid(line,0,semi)
     print,line
    endif
   endrep until not contin
  endif
 endfor
endif

if not valid then message,'not a procedure/function',/continue,/noname

return & end


