;+
; Name        : STRIP_DOC
;
; Purpose     : Strip internal documentation from an IDL program.
;
; Explanation : 
;
; Use         : DOC=STRIP_DOC(ARRAY)
;
; Inputs      : 
;	        ARRAY = string array with text of program.
;
; Outputs     : 
;	        DOC = string array with documentation part.
;
; Category    : Documentation, Online_help.
;
; Written     : Dominic Zarro, ARC, 10 October 1994.
;
;-

function strip_doc,proc            ;-- strip documentation from procedure

on_error,1

tproc='no documentation found'
if datatype(proc) ne 'STR' then begin
 message,'input must be string array',/contin
 return,tproc
endif

np=n_elements(proc)
begun=0 & done=0 & i=-1
repeat begin
 i=i+1 & line=proc(i)
 if not begun then begin
  begun = (strpos(line, ";+") ne -1)
 end else if (strpos(line,";-") ne -1) then begin
  begun = 0				; start again and look for more
 end else begin
  tproc=[tproc,line]
 endelse
endrep until (i eq np-1)		; search whole file
if n_elements(tproc) gt 1 then tproc=tproc(1:*)

return,tproc & end
