;+
; Project     : SOHO - CDS
;
; Name        : TEST_OPEN
;
; Purpose     : Test open a file to determine existence and/or write access
;
; Explanation :
;       Uses OPENR or OPENW (if /WRITE is set) to return status of
;       input file. If input file is not given, then TEST_OPEN will
;       test if the current directory is writeable.
; Use         : 
;	OK=TEST_OPEN(FILE)             ;test for existence
;	OK=TEST_OPEN(FILE,/WRITE)      ;test for write access
; Inputs      : 
;	FILE  = file to test
; Opt. Inputs : 
;	NAME = String containing the name of the procedure.
; Outputs     : 
;	OK   = logical 1 for existence and readable
;                   or 0 for nonexistent and/or not writeable (if /WRITE)
; Opt. Outputs: 
;	None.
; Keywords    : 
;       WRITE = If set, then test for write access.
; Calls       : 
;	None
; Common      : 
;	None.
; Restrictions: 
;	None.
; Side effects: 
;	None.
; Category    : 
;	Utilities, Operating_system.
; Written     : 
;	Dominic Zarro, GSFC, 1993.
; Version     : 
;	Version 1, 1 August 1993.
;-

function test_open,file,write=write

;message,'calling test_open  on '+file,/contin
ok=0
if n_elements(file) eq 0 then begin
 file='test.garbage' & del=1 & app=0
endif else begin
 del=0 & app=1
endelse

if keyword_set(write) then $
 openw,lun,file,/get_lun,delete=del,append=app,error=err else $
  openr,lun,file,/get_lun,error=err

ok=(err eq 0)
if ok then begin 
 handle=fstat(lun)
 file=handle.name
 free_lun,lun & close,lun 
endif

if (not ok) and keyword_set(write) then begin
 message,'denied write permission',/contin
endif

return,ok & end

