	PRO CONTV,ARRAY,MX,MY,JX,JY,LEVELS=LEVELS,COLOR=COLOR,	$
		DISABLE=DISABLE,MAX_VALUE=MAX_VALUE,THICK=THICK,$
		ORIGIN=ORIGIN,SCALE=SCALE
;+
; Project     : SOHO - CDS
;
; Name        : 
;	CONTV
; Purpose     : 
;	Places contour plots over displayed images.
; Explanation : 
;	Places contour plots over images displayed with the EXPTV or similar
;	procedure.
; Use         : 
;	CONTV, ARRAY
;	CONTV, ARRAY, MX, MY, JX, JY
; Inputs      : 
;	ARRAY	 = Image to make contour plot from.  This may have a different
;		   number of pixels as the original image being overlaid.
;		   Also, the origin and pixel scale(s) may differ from the
;		   original image.
; Opt. Inputs : 
;	MX, MY	 = The size of the image on the display screen.
;	JX, JY	 = The position of the lower left-hand corner of the image on 
;		   the display screen.
;
;	If the optional parameters are not passed, then they are retrieved with
;	GET_TV_SCALE.  It is anticipated that these optional parameters will
;	only be used in extremely rare circumstances.
;
; Outputs     : 
;	The values of MX, MY and JX, JY are printed to the terminal screen.
; Opt. Outputs: 
;	None.
; Keywords    : 
;	COLOR	 = Color to use for drawing the contours.
;	LEVELS	 = Levels to use for drawing the contours.
;	MAX_VALUE= Maximum value to use for drawing the contours.  Pixels with
;		   values above MAX_VALUE will be ignored in drawing the
;		   contours.
;	DISABLE  = If set, then TVSELECT not used.
;	THICK	 = Plotting thickness.
;	ORIGIN	 = Two-element array containing the coordinate value in
;		   physical units of the center of the first pixel in the
;		   image.  If not passed, then [0,0] is assumed.
;	SCALE	 = Pixel scale in physical units.  Can have either one or two
;		   elements.  If not passed, then 1 is assumed in both
;		   directions.
; Calls       : 
;	GET_TV_SCALE, TVSELECT, TVUNSELECT
; Common      : 
;	None.
; Restrictions: 
;	ARRAY must be two-dimensional.
;
;	It is important that the user select the graphics device/window, and
;	image region before calling this routine.  For instance, if the image
;	was displayed using EXPTV,/DISABLE, then this routine should also be
;	called with the /DISABLE keyword.  If multiple images are displayed
;	within the same window, then use SETIMAGE to select the image before
;	calling this routine.
;
;	In general, the SERTS image display routines use several non-standard
;	system variables.  These system variables are defined in the procedure
;	IMAGELIB.  It is suggested that the command IMAGELIB be placed in the
;	user's IDL_STARTUP file.
;
;	Some routines also require the SERTS graphics devices software,
;	generally found in a parallel directory at the site where this software
;	was obtained.  Those routines have their own special system variables.
;
; Side effects: 
;	If the optional parameters MX, MY, and JX, JY are passed, then it is
;	assumed that the image being overlaid was displayed with the same
;	settings, and that the scale was in pixels (SCALE=1) with the first
;	pixel in the original image being equivalent to [0,0].
; Category    : 
;	Utilities, Image_display.
; Prev. Hist. : 
;	W.T.T., Oct. 1987.
;	W.T.T., Feb. 1991, modified to use TVSELECT, TVUNSELECT.
;	William Thompson, May 1992, changed to call GET_TV_SCALE.
;	William Thompson, Nov 1992, removed call to INIT_SC1_SC4.
;	William Thompson, Dec 1992, added THICK keyword.
;	William Thompson, Jan 1993, corrected small positioning error.
; Written     : 
;	William Thompson, GSFC, October 1987.
; Modified    : 
;	Version 1, William Thompson, GSFC, 13 May 1993.
;		Incorporated into CDS library.
;	Version 2, William Thompson, GSFC, 3 September 1993.
;		Added ORIGIN and SCALE keywords.  Rewrote to use the graphics
;		scale generated by the routine that displayed the image.  This
;		relaxes some of the restrictions imposed by the original
;		routine.  It is no longer necessary for the overlaid contour
;		plot and the original image to match pixel for pixel.
;	Version 3, William Thompson, GSFC, 9 November 1993.
;		Removed (unnecessary) restriction that scales be positive.
; Version     : 
;	Version 3, 9 November 1993.
;-
;
	ON_ERROR,2
;
;  Check the number of parameters.
;
	IF (N_PARAMS(0) NE 1) AND (N_PARAMS(0) NE 5) THEN BEGIN
		PRINT,'*** CONTV must be called with 1-5 parameters:'
		PRINT,'      ARRAY'
		PRINT,'      ARRAY, MX, MY, JX, JY'
		RETURN
	ENDIF
;
;  Check the input ARRAY.
;
	S = SIZE(ARRAY)
	IF S(0) NE 2 THEN BEGIN
		PRINT,'*** Variable must be two-dimensional, name= ARRAY, routine CONTV.'
		RETURN
	ENDIF
;
;  If necessary, scale ARRAY to the image display screen.
;
	IF N_PARAMS(0) EQ 1 THEN	$
		GET_TV_SCALE,SX,SY,MX,MY,JX,JY,DT,DISABLE=DISABLE
;
	IF (MX LE 0) OR (MY LE 0) THEN BEGIN
		PRINT,'*** Unable to expand array, routine CONTV.'
		RETURN
	ENDIF
	IX = MX / S(1)
	IY = MY / S(2)
;
;  Select the image display device or window.
;
	TVSELECT, DISABLE=DISABLE
;
;  Set the system variables, and save the current values.  The borders of the
;  plot, !SC1-!SC4, are set to the edges of the image.
;
	NOERAS = !NOERAS   &  !NOERAS = -1
	POSITION = !P.POSITION
	XWINDOW  = !X.WINDOW
	YWINDOW  = !Y.WINDOW
	!SC1 = JX
	!SC2 = JX + MX - 1
	!SC3 = JY
	!SC4 = JY + MY - 1
;
;  Retrieve the data coordinates associated with the image, if any.  Save the
;  old clip region.
;
	CLIP = !P.CLIP
	IF N_ELEMENTS(DT) NE 0 THEN BEGIN
		!P.CLIP = DT.CLIP
		DXS = DT.XS
		DYS = DT.YS
	ENDIF
;
;  Unless already set, the scale parameters !CXMIN, !CXMAX, !X.S and !CYMIN,
;  !CYMAX, !Y.S are set by the image.
;
	IF N_ELEMENTS(DT) EQ 0 THEN BEGIN
		XRANGE = [-0.5, S(1) - 0.5]
	END ELSE BEGIN
		XRANGE = ([!SC1,!SC2]/!D.X_SIZE - DXS(0)) / DXS(1)
	ENDELSE
	CXMIN = !CXMIN  &  !CXMIN = XRANGE(0)
	CXMAX = !CXMAX  &  !CXMAX = XRANGE(1)
	XS = !X.S
	!X.S = [!SC1*!CXMAX - !SC2*!CXMIN, !SC2 - !SC1] / $
		(!D.X_SIZE*(!CXMAX - !CXMIN))
;
	IF N_ELEMENTS(DT) EQ 0 THEN BEGIN
		YRANGE = [-0.5, S(2) - 0.5]
	END ELSE BEGIN
		YRANGE = ([!SC3,!SC4]/!D.Y_SIZE - DYS(0)) / DYS(1)
	ENDELSE
	CYMIN = !CYMIN  &  !CYMIN = YRANGE(0)
	CYMAX = !CYMAX  &  !CYMAX = YRANGE(1)
	YS = !Y.S
	!Y.S = [!SC3*!CYMAX - !SC4*!CYMIN, !SC4 - !SC3] / $
		(!D.Y_SIZE*(!CYMAX - !CYMIN))
;
;  Get the image origin.
;
	IF N_ELEMENTS(ORIGIN) EQ 0 THEN BEGIN
		ORIGIN = [0,0]
	END ELSE IF N_ELEMENTS(ORIGIN) NE 2 THEN BEGIN
		MESSAGE,'ORIGIN must have two elements, using [0,0]',/CONTINUE
		ORIGIN = [0,0]
	ENDIF
;
;  Get the image scale.
;
	CASE N_ELEMENTS(SCALE) OF
		0:  BEGIN
			XSCALE = 1
			YSCALE = 1
			END
		1:  BEGIN
			XSCALE = SCALE
			YSCALE = SCALE
			END
		2: BEGIN
			XSCALE = SCALE(0)
			YSCALE = SCALE(1)
			END
	ENDCASE
;
;  Generate the X and Y arrays that control the contour plot.
;
	X = ORIGIN(0) + XSCALE*FINDGEN(S(1))
	Y = ORIGIN(1) + YSCALE*FINDGEN(S(2))
;
;  Do the contour plot.
;
	COMMAND = "CONTOUR,ARRAY,X,Y,XSTYLE=5,YSTYLE=5,TITLE=''," +	$
		"XRANGE=!X.CRANGE,YRANGE=!Y.CRANGE"
	IF N_ELEMENTS(COLOR)  NE 0 THEN COMMAND = COMMAND + ",COLOR=COLOR"
	IF N_ELEMENTS(LEVELS) NE 0 THEN COMMAND = COMMAND + ",LEVELS=LEVELS"
	IF N_ELEMENTS(MAX_VALUE) NE 0 THEN	$
		COMMAND = COMMAND + ",MAX_VALUE=MAX_VALUE"
	IF N_ELEMENTS(THICK)  NE 0 THEN COMMAND = COMMAND + ",THICK=THICK"
	TEST = EXECUTE(COMMAND)
;
;  Restore the system parameters.
;
	!P.POSITION = POSITION
	!X.WINDOW   = XWINDOW
	!Y.WINDOW   = YWINDOW
	!CXMIN = CXMIN  &  !CXMAX = CXMAX
	!CYMIN = CYMIN  &  !CYMAX = CYMAX
	!X.S = XS  &  !Y.S = YS
	!NOERAS = NOERAS
	!P.CLIP = CLIP
	TVUNSELECT, DISABLE=DISABLE
;
	RETURN
	END
