;+
; Project     : SOHO - CDS     
;                   
; Name        : CREATE_TM
;               
; Purpose     : Creates a dummy telemetry file.
;               
; Explanation : Creates a dummy CDS science stream telemetry file by dumping
;               packets of 306 bytes at periodic intervals. Writes the packet
;               index number in the first 2 bytes and the counter bytes (9/10)
;               and if /eng is set also puts '0a'x in byte 19, otherwise just 
;               zeros.
;               
; Use         : IDL> create_tm
;    
; Inputs      : None
;               
; Opt. Inputs : None
;               
; Outputs     : None
;               
; Opt. Outputs: None
;               
; Keywords    : ENG - if present an ID of '0a'x is placed in byte 18 to 
;                     simulate engineering type A packets.
;
; Calls       : None
;
; Common      : None
;               
; Restrictions: Needs write access to the current directory
;               
; Side effects: 
;               
; Category    : Util, telemetry.
;               
; Prev. Hist. : None
;
; Written     : C D Pike, RAL, 6-Jan-95
;               
; Modified    : Add ENG keyword.  CDP, 9-Jan-95
;
; Version     : Version 2, 9-Jan-95
;-            

pro create_tm, eng=eng

;
;  get current realtime file name
;
curr = gt_rt_file()

;
;  open it
;
openw,lun,curr,/get_lun

pkt = bytarr(287)
dum6= bytarr(6)
dum8= bytarr(8)

;
;  engineering?
;
if keyword_set(eng) then id = byte('0a'x) else id = byte(0)

;
;  write packets and switch files on the hour (as in realtime ops)
;
for i=0,20000 do begin
   writeu,lun,i,dum6,i,dum8,id,pkt
   flush,lun
   print,curr,'  pkt # ',i
   new = gt_rt_file()
   if new ne curr then begin
      free_lun,lun
      openw,lun,new,/get_lun
      curr = new
      i = -1
   endif
   wait,0.2
endfor

free_lun,lun

end
