;+
; Project     : SOHO - CDS     
;                   
; Name        : GT_RT_FILE()
;               
; Purpose     : Create expected current CDS telemetry file name.
;               
; Explanation : For realtime operation of STM it needs to know what the
;               current telemetry file name is.  This routine calculates
;               that and STM can then check it exists (ie there is a realtime
;               session in progress).
;               
; Use         : expected = gt_rt_file()
;    
; Inputs      : None
;               
; Opt. Inputs : None
;               
; Outputs     : Function returns a string.
;               
; Opt. Outputs: None
;               
; Keywords    : None
;
; Calls       : None
;
; Common      : None
;               
; Restrictions: None
;               
; Side effects: None
;               
; Category    : Telemetry
;               
; Prev. Hist. : None
;
; Written     : C D Pike, RAL, 5-Jan-95
;               
; Modified    : 
;
; Version     : Version 1, 5-Jan-95
;-            

function gt_rt_file

;
;  get current year
;
get_utc,utc
year = strmid(anytim2cal(utc,form=6),0,2)

;
;  get day of year
;
doy = strmid(string(utc2doy(utc)+1000,form='(i4)'),1,3)


;
;  get UT hour
;
hour = strmid(anytim2cal(utc,form=6),9,2)

return,'tm.' + year + '_' + doy + '_' + hour

end

