;+
; Project     :	SOHO - CDS
;
; Name        :	SHORTHEX()
;
; Purpose     :	Converts a short int value into fixed hex string format.
;
; Explanation :	Converts short integer value in 0xnnnn format.
;
; Use         : <str = shorthex(value)>
;
; Inputs      : value = short integer value.
;
; Opt. Inputs : None.
;
; Outputs     : Character string containing hex value.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;                
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Command preparation.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.00, Martin Carter, RAL, 14/10/94
;
; Modified    :	Version 0.01, Martin Carter, RAL, 28/11/94
;                            Added proforma.
;
; Version     :	Version 0.01, 28/11/94
;-
;**********************************************************

FUNCTION shorthex, value

  str = STRING ( FORMAT='(Z0)', value)

  lstr = STRLEN(str)

  IF lstr LT 4 THEN BEGIN

    ostr = '0x0000'
    STRPUT, ostr, str, 6-lstr

  ENDIF ELSE BEGIN

    ostr = '0x'+STRMID(str,lstr-4,4)

  ENDELSE

  RETURN, ostr

END
