;+
; Project     : SOHO - CDS     
;                   
; Name        : UNSIGN()
;               
; Purpose     : Produces longword equivalent of an unsigned 16-bit integer.
;               
; Explanation : If an unsigned 16-bit value is held internally in IDL in an
;               INT variable, overflow can occur.  This routine translates 
;               the value to a longword so that the value can be handled as
;               required.
;               
; Use         : lword = unsign( int16 )
;    
; Inputs      : int16  - 16-bit integer whose bytes represent an unsigned
;                        2-byte integer.
;               
; Opt. Inputs : None
;               
; Outputs     : Function returns the longword equivalent.
;               
; Opt. Outputs: None
;               
; Keywords    : None
;
; Calls       : None
;               
; Restrictions: None
;               
; Side effects: None
;               
; Category    : Util, numerical
;               
; Prev. Hist. : Original by MK Carter
;
; Written     : CDS version by C D Pike, RAL, 22-Oct-93
;               
; Modified    : Version 1, C D Pike, RAL 22-Oct-93
;		Version 2, William Thompson, GSFC, 19 November 1993.
;			Modified to speed up.  Added DATATYPE check.
;
; Version     : Version 2, 19 November 1993.
;-            

FUNCTION unsign , value 

IF DATATYPE(VALUE,1) NE 'Integer' THEN MESSAGE,	$
	'Input array must be short integer'

RETURN, LONG(VALUE) AND 'FFFF'X

END
