        FUNCTION CHKLOG,VAR,OS
;+
; Project     : SOHO - CDS
;
; Name        : 
;	CHKLOG
; Purpose     : 
;	Determine actual name of logical or environment variable.
; Explanation : 
;	This routine determines the actual name of a logical name (VMS) or
;	environment variable (UNIX).  In VMS the routine TRNLOG,/FULL is used;
;	otherwise GETENV is used.
; Use         : 
;	Result = CHKLOG( VAR  [, OS ] )
; Inputs      : 
;	VAR = String containing the name of the variable to be translated.
; Opt. Inputs : 
;	None.
; Outputs     : 
;	The result of the function is the translated name, or (in VMS) an array
;	containing the translated names.
; Opt. Outputs: 
;       OS = The name of the operating system, from !VERSION.OS.
; Keywords    : 
;	None.
; Calls       : 
;	None.
; Common      : 
;	None.
; Restrictions: 
;	None.
; Side effects: 
;	None.
; Category    : 
;	Utilities, Operating_system.
; Prev. Hist. : 
;       Written  - DMZ (ARC) May 1991
;       Modified - DMZ (ARC) Nov 1992, to use GETENV
; Written     : 
;	D. Zarro, GSFC/SDAC, May 1991.
; Modified    : 
;	Version 1, William Thompson, GSFC, 23 April 1993.
;		Incorporated into CDS library.
;       Version 2, Dominic Zarro, GSFC, 1 August 1994.
;               Added capability for vector inputs
; Version     : 
;	Version 2, 1 August 1994.
;-
;

on_error,1
if n_elements(var) eq 0 then begin
 message,'invalid input',/contin
 return,''
endif
svar=var

os=!version.os

for i=0,n_elements(svar)-1 do begin
 var=svar(i)
 
 if os eq 'vms' then begin
  colon=strpos(var,':')
  if colon eq (strlen(var)-1) then tvar=strmid(var,0,strlen(var)-1) else tvar=var
  s=execute('v=trnlog(tvar,name,/full)')
  if (v mod 2) eq 0 then name=''
 endif else begin
  doll=strpos(var,'$')
  if doll eq 0 then tvar=strmid(var,1,1000) else tvar=var
  slash=strpos(tvar,'/')
  if slash eq (strlen(tvar)-1) then tvar=strmid(tvar,0,strlen(tvar)-1) 
  name=getenv(tvar)
 endelse

 if i eq 0 then rvar=name else rvar=[rvar,name]

endfor

var=svar
if n_elements(rvar) eq 1 then rvar=rvar(0)
return,rvar & end
