;----------------------------------------------------------------------
; Document name: grep.pro
; Created by:    Liyun Wang, GSFC/ARC, December 15, 1994
;
; Last Modified: Fri Dec 16 11:05:37 1994 (lwang@orpheus.nascom.nasa.gov)
;----------------------------------------------------------------------
;
FUNCTION GREP, str, strarray, sensitive=sensitive, exact=exact
;+
; PROJECT:
;       SOHO - CDS
;
; NAME:
;       GREP()
;
; PURPOSE:
;       Search for a string through a string array (cf grep in Perl)
;
; EXPLANATION:
;
; CALLING SEQUENCE:
;       Result = GREP(str, strarray)
;
; INPUTS:
;       STR      - Target string to be searched for
;       STRARRAY - String array over which the string is seached
;
; OPTIONAL INPUTS:
;       None.
;
; OUTPUTS:
;       Result   - String array of elements from STRARRAY which contains
;                  the searched string STR. A null string will be returned if
;                  no elements in STRARRAY match STR.
;
; OPTIONAL OUTPUTS:
;       None.
;
; KEYWORD PARAMETERS:
;       SENSITIVE  - Make the search pattern case sensitive, if set
;       EXACT      - Requires exact match (instead of substring match)
;
; CALLS:
;       DATATYPE
;
; COMMON BLOCKS:
;       None.
;
; RESTRICTIONS:
;       None.
;
; SIDE EFFECTS:
;       None.
;
; CATEGORY:
;
; PREVIOUS HISTORY:
;       Written December 15, 1994, Liyun Wang, GSFC/ARC
;
; MODIFICATION HISTORY:
;
; VERSION:
;       Version 1, December 15, 1994
;-
;
   ON_ERROR, 2
   IF datatype(str) NE 'STR' OR datatype(strarray) NE 'STR' THEN $
      MESSAGE, 'Input parameter must be of string type.'
   nn = N_ELEMENTS(strarray)
   aa = strarray
   a = str
   IF NOT KEYWORD_SET(sensitive) THEN BEGIN
      aa = STRUPCASE(aa)
      a = STRUPCASE(a)
   ENDIF

   IF KEYWORD_SET(exact) THEN BEGIN
      FOR i = 0, nn-1 DO BEGIN
         IF (a EQ aa(i)) THEN BEGIN
            IF N_ELEMENTS(ccc) EQ 0 THEN ccc = strarray(i) ELSE $
               ccc = [ccc, strarray(i)]
         ENDIF
      ENDFOR
   ENDIF ELSE BEGIN
      FOR i = 0, nn-1 DO BEGIN
         id = STRPOS(aa(i),a)
         IF (id GE 0) THEN BEGIN
            IF N_ELEMENTS(ccc) EQ 0 THEN ccc = strarray(i) ELSE $
               ccc = [ccc, strarray(i)]
         ENDIF
      ENDFOR
   ENDELSE
   IF N_ELEMENTS(ccc) NE 0 THEN RETURN, ccc ELSE RETURN, ''
END

;----------------------------------------------------------------------
; End of 'grep.pro'.
;----------------------------------------------------------------------
