;+
; Project     : SOHO - CDS     
;                   
; Name        : PRINT_STR
;               
; Purpose     : Divide and print a string.
;               
; Explanation : Divides a string into an array (using supplied delimiter)
;               and prints one element per line.  Most obvious use is to 
;               print !path. If input is already a string vector then just
;               print the elements one per line.
;               
; Use         : IDL> print_str, string, delim=delim
;    
; Inputs      : string - the string to be split and printed
;               
; Opt. Inputs : None
;               
; Outputs     : Results are printed to screen
;               
; Opt. Outputs: None
;               
; Keywords    : Delim - a substring to delimit the string items, default is ':'
;               Hard  - produce a hard copy.
;
; Calls       : STR2ARR
;
; Common      : None
;               
; Restrictions: None
;               
; Side effects: None
;               
; Category    : Util, string
;               
; Prev. Hist. : None
;
; Written     : C D Pike, RAL, 20-July-94
;               
; Modified    : Add print delay as fudge.  CDP, 9-Dec-94
;               Handle vector input.  CDP, 23-Dec-94
;
;               Added hardcopy keyword.  CDP, 20-Feb-95
;
; Version     : Version 3, 20-Feb-95
;-            

pro print_str, str, delim=delim, hard=hard

;
;  help user
;
if n_params() eq 0 then begin
   print,'Use: IDL> print_str, string, delim=delim'
   return
endif

if datatype(str,1) ne 'String' then begin
   print,'Input must be a string variable'
   return
endif

;
;  define delimiter
;
if not keyword_set(delim) then delim = ':'


;
;  break it up if needed
;
if (size(str))(0) eq 0 then x = str2arr(str,delim=delim) else x=str

;
;  hard copy?
;
if keyword_set(hard) then begin
   openw,lun,'print_str.tmp',/get_lun
endif

;
; print it, include wait to fudge synch problem on alphas/idl3.5?
;
for i=0,n_elements(x)-1 do begin
   if i gt 50 then wait,0.02
   print,x(i)
   if keyword_set(hard) then printf,lun,x(i)
endfor

;
;  close and print hard copy
;
if keyword_set(hard) then begin
   free_lun,lun
   spawn,'lpr print_str.tmp'
   print,'Hard copy submitted to printer.'
endif
end

