;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Document name: str_comb.pro
; Created by:    Liyun Wang, GSFC/ARC, October 7, 1994
;
; Last Modified: Fri Oct  7 19:06:04 1994 (lwang@orpheus.gsfc.nasa.gov)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
FUNCTION STR_COMB, strings, delimit
;+
; PROJECT:
;       SOHO - CDS
;
; NAME:	
;       STR_COMB()
;
; PURPOSE:
;       To concatinate a string array into a single string scalar.
;
; EXPLANATION:
;       
; CALLING SEQUENCE: 
;       Result = STR_COMB(strings [, delimit])
;
; INPUTS:
;       STRINGS -- A string array
;
; OPTIONAL INPUTS: 
;       DELIMIT -- A string scalar as the delimiter of the strings. If absent,
;                  no charater will be added between two strings
;
; OUTPUTS:
;       RESULT -- A string scalar
;
; OPTIONAL OUTPUTS:
;       None.
;
; KEYWORD PARAMETERS: 
;       None.
;
; CALLS:
;       None.
;
; COMMON BLOCKS:
;       None.
;
; RESTRICTIONS: 
;       None.
;
; SIDE EFFECTS:
;       None.
;
; CATEGORY:
;       
; PREVIOUS HISTORY:
;       Written October 7, 1994, by Liyun Wang, GSFC/ARC
;
; MODIFICATION HISTORY:
;       
; VERSION:
;       Version 1, October 7, 1994
;-
;
   ON_ERROR, 2
   
   n = N_PARAMS()
   IF n EQ 0 THEN $
      MESSAGE, 'Syntax: result=str_comp(string_arr [,delimiter])'

   IF datatype(strings) NE 'STR' THEN $
      MESSAGE, 'Input parameter must be of string type.'
   
   IF n EQ 1 THEN BEGIN
      result = strings(0)
      IF N_ELEMENTS(strings) GT 1 THEN BEGIN
         FOR i = 2, N_ELEMENTS(strings) DO BEGIN
            result = result+strings(i-1)
         ENDFOR
      ENDIF
   ENDIF ELSE BEGIN
      IF datatype(delimit) NE 'STR' THEN $
         MESSAGE, 'Input parameter must be of string type.' 
      result =  strings(0)
      IF N_ELEMENTS(strings) GT 1 THEN BEGIN
         FOR i = 2, N_ELEMENTS(strings) DO BEGIN
            result = result+delimit+strings(i-1)
         ENDFOR
      ENDIF
   ENDELSE
   RETURN, result 
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; End of 'str_comb.pro'.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
