;+
; Project     : SOHO - CDS     
;                   
; Name        : STRPAD()
;               
; Purpose     : Pads a string with blanks to specified width
;
;              
; Explanation : Spaces are added in front of the input string to
;		make the returned string have LENGTH characters.
;		Use /AFTER to add spaces at the end.
;               
; Use         : STR = STRPAD(VALUE,LENGTH)
;    
; Inputs      : VALUE:  A string..
;		LENGTH: The desired length of the result in characters
;               
; Opt. Inputs : None.
;               
; Outputs     : Returns the padded string.
;               
; Opt. Outputs: None.
;               
; Keywords    : AFTER : Set to add spaces at the end.
;
; Calls       : STRLEN, STRMID
;
; Common      : None.
;               
; Restrictions: Value must be a scalar string
;               
; Side effects: If the input string is longer than the desired
;		width, it is returned without truncation
;               
; Category    : Utilities, Strings
;               
; Prev. Hist. : None.
;
; Written     : Stein Vidar Hagfors Haugan, 27 September 1993
;               
; Modified    : Corrected typo which stopped /after working.  CDP, 28-Sep-94
;               Increased possible length used.  CDP, 22-Dec-94
;               Handle arrays of strings.  CDP, 16-Mar-95
;
; Version     : Version 4, 16-Mar-95
;-            


FUNCTION StrPad,txt,length,after=after
;
;  check basic input 
;
if datatype(txt,1) ne 'String' then begin
   print,'Input must be of type STRING'
   return, ''
endif


;
;  is it an array?
;
n = n_elements(txt)

;
;  loop to handle arrays
;
spc = "                                                                     "
spc = spc+"                                                                 "
for i=0,n-1 do begin
  IF strlen(txt(i)) lt length THEN BEGIN
      IF Keyword_SET(after) THEN BEGIN
         txt(i) = txt(i) + strmid(spc,0,length-strlen(txt(i)))
      ENDIF ELSE BEGIN
         txt(i) = strmid(spc,0,length-(strlen(txt(i))))+txt(i)
      ENDELSE
  ENDIF
endfor

return,txt

END
