;+
; Project     :	SDAC
;
; Name        :	ADD_TAG
;
; Purpose     :	add a tag to a structure
;
; Explanation :	
;
; Use         : NEW_STRUCT=ADD_TAG(STRUCT,TAG,NAME)
;
; Inputs      :	STRUCT = input structure
;             : TAG = tag variable to add (scalar or vector)
;             : NAME = tag name (scalar or vector)
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = new structure
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	COPY_STRUCT
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 7 November 1994
;-

function add_tag,struct,tag,name      
on_error,1

mess='NEW_STRUCT=ADD_TAG(STRUCT,TAG,NAME)'
ntag=n_elements(tag)
if ntag eq 0 then message,mess
if datatype(name) ne 'STR' then message,mess
name=strtrim(name,2)
anon=where(name eq '',cnt)
if cnt gt 0 then message,mess
nname=n_elements(name)
if datatype(tag) eq 'STC' then ntag=1
if (datatype(struct) ne 'STC') or (nname ne ntag) then message,mess

new_struct=0

;-- start with original tags

tags=tag_names(struct)
str=''
for i=0,n_elements(tags)-1 do begin
 str=str+tags(i)+':struct.('+string(i)+'),'
endfor

;-- add requested tags (nesting structures)

if datatype(tag) eq 'STC' then begin
 str=str+name+':tag} 
endif else begin
 for k=0,ntag-1 do begin
  if k eq (ntag-1) then sep='}' else sep=','
  str=str+name(k)+':tag('+string(k)+')'+sep
 endfor
endelse

str=strtrim(strcompress(str,/rem),2)
s=execute('new_struct={'+str)

return,new_struct & end

