;+
; Project     :	SOHO - CDS
;
; Name        :	CONCAT_STRUCT
;
; Purpose     :	concatanate two structures
;
; Explanation :	concatanates two structures by using COPY_STRUCT to
;               avoid the problem of concatanating two differently named
;               structures.
;
; Use         : NEW_STRUCT=CONCAT_STRUCT(STRUCT1,STRUCT2)
;
; Inputs      :	STRUCT1,2 = input structures
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = concatanated structure
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	COPY_STRUCT
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 22 September 1994
;-


function concat_struct,struct1,struct2      ;-- concat two structures

on_error,1


if (datatype(struct1) ne 'STC') or (datatype(struct2) ne 'STC')  then begin
 if (datatype(struct1) eq 'STC') then return,struct1
 if (datatype(struct2) eq 'STC') then return,struct2
 message,'invalid input structures'
endif

new_struct=0

n1=tag_names(struct1,/struct)
n2=tag_names(struct2,/struct)
if (n1 eq n2) and (n1 ne '') then begin
 new_struct=[struct1,struct2]
endif else begin
 temp=replicate(struct1(0),n_elements(struct2))
 copy_struct,struct2,temp
 new_struct=[struct1,temp]
endelse

return,new_struct & end

