;+
; Project     :	SOHO - CDS
;
; Name        :	JOIN_STRUCT
;
; Purpose     :	join two structures
;
; Explanation :	concatanates two structures by using COPY_STRUCT to
;               avoid the problem of concatanating two differently named
;               structures.
;
; Use         : NEW_STRUCT=JOIN_STRUCT(STRUCT1,STRUCT2)
;
; Inputs      :	STRUCT1,2 = input structures
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = concatanated structure
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	COPY_STRUCT
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 22 September 1994
;-


function join_struct,struct1,struct2,_extra=extra      ;-- join two structures

on_error,1

if (datatype(struct1) ne 'STC') or (datatype(struct2) ne 'STC')  then begin
 if (datatype(struct1) eq 'STC') then return,struct1
 if (datatype(struct2) eq 'STC') then return,struct2
 message,'invalid input structures'
endif

s1=tag_names(struct1,/struct)
s2=tag_names(struct2,/struct)

new_struct=0
if (s1 eq s2) and (s1 ne '') then return,[struct1,struct2]

n1=n_elements(struct1)
n2=n_elements(struct2)
new_struct=replicate(struct1(0),n1+n2)

for i=0,n1-1 do begin
 temp=new_struct(0)
 copy_struct,struct1(i),temp,_extra=extra & new_struct(i)=temp
endfor

for i=n1,n1+n2-1 do begin
 temp=new_struct(0)
 copy_struct,struct2(i-n1),temp,_extra=extra & new_struct(i)=temp
endfor

return,new_struct & end

