;+
; Project     :	SDAC
;
; Name        :	MATCH_STRUCT
;
; Purpose     :	check if two structures are identical
;
; Explanation :	cross-checks type and value of each field
;
; Use         : STATUS=MATCH_STRUCT(STRUCT1,STRUCT2)
;
; Inputs      :	S1, S2 = input structures
;
; Opt. Inputs :	None.
;
; Outputs     :	STATUS = 1/0 is input structure are/are not identical
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	DATATYPE
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC/GSFC)
;
; Modified    : To handle arrays of strings.  CDP, 27-Feb-95
;               Removed redunant string check. DMZ, 1-March-95
;
; Version     :	Version 3, 1-March-95
;
;-

function match_struct,s1,s2

on_error,1

status=0b
if (datatype(s1) ne 'STC') or (datatype(s2) ne 'STC') then begin
 message,'syntax --> STATUS=MATCH_STRUCT(STRUCT1,STRUCT2)',/contin
 return,status
endif

;-- check that input structures have same number of tags

t1=tag_names(s1) & t2=tag_names(s2)
if n_elements(t1) ne n_elements(t2) then return,status

;-- check that everything else matches

for i=0,n_elements(t1)-1 do begin
 if t1(i) ne t2(i) then return,status
 f1=s1.(i) & f2=s2.(i)
 if datatype(f1) ne datatype(f2) then return,status

 case 1 of

;-- structure case

  datatype(f1) eq 'STC' : begin   
   status=match_struct(f1,f2)
  end

;-- vector or scalar

  else: begin
   clook=where( (f2 eq f1) eq 1,cnt)
   status=(cnt eq n_elements(f1))
  end

 endcase

 if total(status) ne n_elements(status) then return,0b
endfor

;-- made it this far, so must be ok

status=1b

return,status & end

