;+
; Project     :	SDAC
;
; Name        :	REM_TAG
;
; Purpose     :	remove a tag from a structure
;
; Explanation :	
;
; Use         : NEW_STRUCT=REM_TAG(STRUCT,TAG)
;
; Inputs      :	STRUCT = input structure
;             : TAG = array of tag names to remove
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = new structure
;
; Opt. Outputs:	None.
;
; Keywords    :	NAME = new name for output structure
;
; Calls       :	COPY_STRUCT
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 7 November 1994
;-


function rem_tag,struct,tag,name=name

on_error,1

if (datatype(struct) ne 'STC') then begin
 message,'syntax --> NEW_STRUCT=REM_TAG(STRUCT,TAG)
endif
if datatype(name) ne 'STR' then name='' else name=name+','
if n_elements(tag) eq 0 then return,struct
new_struct=0

tags=tag_names(struct)

str=''
for i=0,n_elements(tags)-1 do begin
 clook=where(tags(i) eq strupcase([tag]),cnt)
 if cnt eq 0 then str=str+','+tags(i)+':struct.('+string(i)+')'
endfor

str=strcompress(str,/rem)
str=strmid(str,1,strlen(str))
state='new_struct={'+name+str+'}'

s=execute(state)

return,new_struct & end

