;+
; Project     :	SDAC
;
; Name        :	REP_TAG
;
; Purpose     :	Replace a tag name in structure
;
; Explanation :	
;
; Use         : NEW_STRUCT=REP_TAG(STRUCT,OLD_TAG,NEW_TAG)
;
; Inputs      :	STRUCT = input structure
;             : OLD_TAG = old tag name
;             : NEW_TAG = new tag name
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = new structure
;
; Opt. Outputs:	None.
;
; Keywords    :	NAME = new name for output structure
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 7 November 1994
;-


function rep_tag,struct,old_tag,new_tag,name=name

on_error,1

err=0
if (datatype(struct) ne 'STC') then err=1
if n_elements(new_tag)*n_elements(old_tag) eq 0 then err=1
if err then  message,'syntax --> NEW_STRUCT=REP_TAG(STRUCT,OLD_TAG,NEW_TAG)

new_struct=0
if datatype(name) ne 'STR' then name='' else name=name+','
tags=tag_names(struct)
str=''
clook=where(tags eq strupcase(old_tag),cnt)
if cnt eq 0 then return,struct
tags(clook)=new_tag

for i=0,n_elements(tags)-1 do str=str+','+tags(i)+':struct.('+string(i)+')'
str=strcompress(str,/rem)
str=strmid(str,1,strlen(str))
state='new_struct={'+name+str+'}'

s=execute(state)

return,new_struct & end

