;+
; Project     : SOHO - CDS     
;                   
; Name        : DAYS2LAUNCH()
;               
; Purpose     : Calculates days until SOHO launch.
;               
; Explanation : As above.
;               
; Use         : IDL> print,days2launch()
;    
; Inputs      : None
;               
; Opt. Inputs : None
;               
; Outputs     : Function returns value required.
;               
; Opt. Outputs: None
;               
; Keywords    : None
;
; Calls       : Util time routines.
;
; Common      : None
;               
; Restrictions: None
;               
; Side effects: None
;               
; Category    : Help
;               
; Prev. Hist. : None
;
; Written     : C D Pike, 13-Feb-95
;               
; Modified    : Change launch to 30-Oct-95.  CDP, 25-May-95
;               Change launch date to 7 November, 21-Aug-95
;               Change launch date to 16-December (provisional). 4-Sep-95
;               Change launch date to 23-November (the final?). 27-Oct-95
;               Change to rescheduled launch.   27-Nov-95
;               Change to post-launch message.  04-Dec-95
;               Apparently mission started on day 1, not 0.  CDP, 9-Feb-96
;
; Version     : Version 8, 09-Feb-96
;-            

function days2launch

;
;  Set latest launch date
;
launch = '2-Dec-1995 08:08'
lutc = utc2tai(str2utc(launch,/dmy))

;
;  get current day
;
get_utc,utc
utc = utc2tai(utc)

;
;  days into mission....
;
d2l = fix((utc - lutc)/(3600.*24.)) + 1

;
;  and return the good news
;
return, d2l

end
