pro textclose,textout=textout
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	TEXTCLOSE                   
; Purpose     :	
;	Closes file specified by !TEXTOUT.  Used by ASTRON routines.
; Explanation :	
;	Procedure to close file for text output as specifed
;	by the (non-standard) system variable !TEXTOUT. 
;
; Use         :	
;	textclose, [ TEXTOUT = ]
;
; Inputs      :	None.
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	
;	textout - Indicates output device that was used by
;		TEXTOPEN
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	
;	if !textout is not equal to 5 and the textunit is
;	opened.   Then unit !textunit is closed and released
;
; Category    :	Utilities, User_interface
;
; Prev. Hist. :	
;	D. Lindler  Dec. 1986  (Replaces PRTOPEN)
;	Test if TEXTOUT is a scalar string   W. Landsman   August 1993
;
; Written     :	D. Lindler, GSFC/HRS, December 1986
;
; Modified    :	Version 1, William Thompson, GSFC, 30 March 1994
;			Incorporated into CDS library
;
; Version     :	Version 1, 30 March 1994
;-
;
;-----------------------------------------------------------
; CLOSE PROPER UNIT
;

 if N_elements( textout ) EQ 0 then textout = !textout ;use default

 ptype = size( textout )           ;Test if TEXTOUT is a scalar string
 if ptype(1) EQ 7  then text_out = 6 else text_out = textout

 if ( text_out NE 5 ) then begin
	if !textunit ne 0 then begin
		free_lun, !TEXTUNIT  
                !textunit = 0
	end
 end

 return
 end
