; $Id: pickfile.pro,v 1.2 1993/08/20 21:56:57 steve Exp $

;
; Copyright (c) 1991-1993, Research Systems, Inc.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	CDSPICKFILE
;
; PURPOSE:
;	This function allows the user to interactively pick a file.  A file
;	selection tool with a graphical user interface is created.  Files
; 	can be selected from the current directory or other directories.
;
; CATEGORY:
;	Widgets.
;
; CALLING SEQUENCE:
;	Result = CDSPICKFILE()
;
; KEYWORD PARAMETERS:
;
;	FILE:	A string value for setting the initial value of the
;		selection. Useful if there is a default file
;
;	GET_PATH: Set to a named variable. Returns the path at the
;		time of selection.
;
;	GROUP:	The widget ID of the widget that calls CDSPICKFILE.  When this
;		ID is specified, a death of the caller results in the death of
;		the CDSPICKFILE widget application.
;
;	READ:	Set this keyword to make the title of the CDSPICKFILE window 
;		"Select File to Read".
;
;	WRITE:	Set this keyword to make the title of the CDSPICKFILE window 
;		"Select File to Write".
;
;	PATH:	The initial path to select files from.  If this keyword is 
;		not set, the current directory is used.
;
;	FILTER:	A string value for filtering the files in the file list.  This
;		keyword is used to reduce the number of files to choose from.
;		The user can modify the filter unless the FIX_FILTER keyword
;		is set.  Example filter values might be "*.pro" or "*.dat".
;
;	FIX_FILTER: When this keyword is set, only files that satisfy the
;		filter can be selected.  The user has no ability to modify
;		the filter and the filter is not shown.
;
;	TITLE:	A scalar string to be used for the window title.  If it is
;		not specified, the default title is "Select File"
;
;	NOCONFIRM: Return immediately upon selection of a file.  The default
;		behavior is to display the selection and then return the
;		file when the user uses the "ok" button.
;
;	MUST_EXIST: When set, only files that actually exist can be selected.
;
; OUTPUTS:
;	CDSPICKFILE returns a string that contains the name of the file selected.
;	If no file is selected, CDSPICKFILE returns a null string.
;
; COMMON BLOCKS:
;	CDSPICKER:	COMMON block that maintains state for the widget.
;
; SIDE EFFECTS:
;	This function initiates the XMANAGER if it is not already running.
;
; RESTRICTIONS:
;	This routine is known to work on Suns (OPEN LOOK), MIPS, RS/6000, 
;	DEC Ultrix, HP/700, VAX/VMS and SGI machines.
;
;	Only one instance of the CDSPICKFILE widget can be running at one time.
;
;	CDSPICKFILE does not recognize symbolic links to other files in UNIX.
;
; PROCEDURE:
;	Create and register the widget and then exit, returning the filename
;	that was picked.
;
; EXAMPLE:
;	Create a CDSPICKFILE widget that lets users select only files with 
;	the extensions 'pro' and 'dat'.  Use the 'Select File to Read' title 
;	and store the name of the selected file in the variable F.  Enter:
;
;		F = CDSPICKFILE(/READ, FILTER = '*.pro *.dat')
;
; MODIFICATION HISTORY:
; 	Written by:	Steve Richards,	April, 1991
;	July, 1991	Added a FILTER keyword to allow users
;			to select files with a given extension or 
;			extensions.
;	August, 1991	Fixed bugs caused by differences between
;			spawned ls commands on different machines.
;	September, 1991	Made Myfindfile so only one pass was
;			necessary to find files and directories.
;	3/92 - ACY	Corrected initialization of dirsave, change spawn
;			command to "ls -lL" and added case for links
;			add NOCONFIRM keyword for auto exiting on selection
;	8/92 - SMR	Rewrote cdspickfile as a compound widget.
;	10/92 - SMR	Fixed a bug where extremely large file namess didn't
;			show up properly in the file list or as return
;			values.
;	12/92 - JWG	Add better machine dependency code
;	1/93 - JWG	Added FILE, GET_PATH keywords.
;	1/93 - TAC	Added Windows Common dialog cdspickfile code
;	2/93 - SMR	Fixed the documentation example for multiple extensions
;-

;
; Fake OS_PICKFILE for non-Windows Machines
FUNCTION OS_PICKFILE,	$
		GROUP=g, PATH=p, READ=r, WRITE=w, $
		FILTER=F, TITLE=T, NOCONFIRM=n,	$
		MUST_EXIST=m, FIX_FILTER=ff, $
		FILE=file, GET_PATH=gp
  RETURN, 0
END

FUNCTION valid_dir, dir
  Widget_CONTROL, /HOUR
  CASE !VERSION.OS OF
      
      'vms': BEGIN
	  CD, current =	here
	  dir =	dir + "*.*"
	  context = 0L
	  resultant = STRING(BYTARR(256)+32B)
;	    result = CALL_EXTERNAL("LIBRTL", "LIB$FIND_FILE", dir, resultant, context, here, 0L, 0L, 0L, VALUE = [0, 0, 0, 0, 1, 1, 1])
	  toss = CALL_EXTERNAL("LIBRTL", "LIB$FIND_FILE_END", context)
	  RETURN, (result EQ 65537)
      END
      'windows': BEGIN
	  RETURN,1    ; Hook into common dialogs for windows
		      ; when this really works.
      END
      ELSE:  BEGIN
	  SPAWN, ['/bin/sh -c "test -d ' + dir + '" && echo 1'], result
	  RETURN, Keyword_SET( result )
      END
  EndCASE
END

;------------------------------------------------------------------------------
;	procedure GETDIR
;------------------------------------------------------------------------------
; This routine finds the files or directories at the current directory level.
; It must be called with either files or directories as a keyword.
;------------------------------------------------------------------------------

FUNCTION getdirs
  
  Widget_CONTROL, /HOUR
  
  IF (!VERSION.OS EQ "vms") THEN BEGIN			  ;version is VMS who's
      retval = ['[-]']
      results =	findfile("*.DIR")			    ;directories have an
      IF(Keyword_SET(results)) THEN BEGIN		    ;extension of ".dir"
	  endpath = STRPOS(results(0), "]", 0) + 1
	  results = strmid(results, endpath, 100)
	  dirs = WHERE(STRPOS(results, ".DIR", 0) NE -1, found)
	  IF (found GT 0) THEN BEGIN
	      results =	results(dirs)
	      retval = [retval,	results]
	  EndIF
      EndIF
  EndIF	ELSE IF	!VERSION.OS EQ "windows" THEN BEGIN
      message,"Unsupported on this platform"
  EndIF	ELSE BEGIN
      retval = ['../']
      SPAWN, "ls -lL", results
      numfound = N_elements(results)
      IF(Keyword_SET(results)) THEN BEGIN		    ;extension of ".dir"
	  firsts = STRUPCASE(STRMID(results, 0,	1))
	  dirs = (where(firsts EQ "D", found))
	  IF (found GT 0) THEN BEGIN
	      results =	results(dirs)
	      spaceinds	= WHERE(BYTE(results(0)) EQ 32)
	      spaceindex = spaceinds(N_elements(spaceinds)-1)
	      retval = [retval,	STRMID(results,	spaceindex + 1,	100)]
	  EndIF
      EndIF
  EndELSE
  RETURN, retval
END ; function getdirs

;------------------------------------------------------------------------------

FUNCTION getfiles, filter
  
  Widget_CONTROL, /HOUR
  
  IF (!VERSION.OS EQ "vms") THEN BEGIN
      results =	findfile(filter)
      IF (Keyword_SET(results))	THEN BEGIN
	  endpath = STRPOS(results(0), "]", 0) + 1
	  results = strmid(results, endpath, 100)
	  dirs = WHERE(STRPOS(results, ".DIR", 0) EQ -1, found)
	  IF (found GT 0) THEN BEGIN
	      results =	results(dirs)
	      return, results
	  EndIF
      EndIF
  EndIF	ELSE IF	!VERSION.OS EQ "windows" THEN BEGIN
      message,"Unsupported on this platform"
  EndIF	ELSE BEGIN
      SPAWN, ["/bin/sh", "-c", "ls -lL " + filter + $
	      " 2> /dev/null"],	results, /NOSHELL
      IF(Keyword_SET(results)) THEN BEGIN
	  firsts = STRUPCASE(STRMID(results, 0,	1))
	  fileinds = (WHERE(((firsts EQ	"F") OR	(firsts	EQ "-")	OR $
			     (firsts EQ	"l")), found))
	  IF (found GT 0) THEN BEGIN
	      results =	results(fileinds)
	      FOR i = 0, N_elements(results) - 1 DO BEGIN
		  spaceinds = WHERE(BYTE(results(i)) EQ	32)
		  spaceindex = spaceinds(N_elements(spaceinds) - 1)
		  results(i) = STRMID(results(i), spaceindex + 1, 100)
	      EndFOR
	      RETURN, results
	  EndIF
      EndIF
  EndELSE
  RETURN, ""
END

;------------------------------------------------------------------------------
;	procedure Cdspickfile_ev
;------------------------------------------------------------------------------
; This procedure processes the events being sent by the XManager.
;------------------------------------------------------------------------------
PRO Cdspickfile_ev, event
  
  common cdspicker, pathtxt, filttxt, dirlist, filelist, selecttxt, $
	  ok, cancel, help, here, thefile, separator
  
  Widget_CONTROL, filttxt, Get_VALUE = filt
  filt = filt(0)
  
  CASE event.id	OF
      
      cancel: BEGIN
	  thefile = ""
	  Widget_CONTROL, event.top, /DESTROY
      END
      
      filttxt: BEGIN
	  files	= getfiles(filt)
	  Widget_CONTROL, filelist, Set_VALUE =	files
	  Widget_CONTROL, filelist, Set_UVALUE = files
      END
      
      dirlist: BEGIN
	  Widget_CONTROL, dirlist, Get_UVALUE =	directories
	  IF (event.index GT N_elements(directories) - 1) THEN RETURN
	  IF (!version.os EQ "vms") THEN BEGIN
	      found = STRPOS(directories(event.index), ".", 0)
	      CD, STRMID(directories(event.index), 0, found)
	      CD, CURRENT = here
	  EndIF	ELSE IF	!version.os EQ "windows" THEN BEGIN
	      message,"Unsupported on this platform"
	  EndIF	ELSE BEGIN
	      CD, directories(event.index)
	      CD, CURRENT = here
	      here = here + separator
	  EndELSE
	  Widget_CONTROL, pathtxt, Set_VALUE = here
	  directories =	getdirs()
	  files	= getfiles(filt)
	  Widget_CONTROL, filelist, Set_VALUE =	files
	  Widget_CONTROL, filelist, Set_UVALUE = files
	  Widget_CONTROL, dirlist, Set_VALUE = directories
	  Widget_CONTROL, dirlist, Set_UVALUE =	directories
      END
      
      pathtxt: BEGIN
	  Widget_CONTROL, pathtxt, Get_VALUE = newpath
	  newpath = newpath(0)
	  len =	STRLEN(newpath)	- 1
	  IF STRPOS(newpath, '/', len) NE -1 THEN $
	    newpath = STRMID(newpath, 0, len)
	  IF (valid_dir(newpath(0))) THEN BEGIN
	      here = newpath(0)	+ separator
	      CD, here
	      directories = getdirs()
	      files = getfiles(filt)
	      Widget_CONTROL, filelist,	Set_VALUE = files
	      Widget_CONTROL, filelist,	Set_UVALUE = files
	      Widget_CONTROL, dirlist, Set_VALUE = directories
	      Widget_CONTROL, dirlist, Set_UVALUE = directories
	  EndIF	ELSE $
	    Widget_CONTROL, pathtxt, Set_VALUE = here
      END
      
      filelist:	BEGIN
	  Widget_CONTROL, filelist, Get_UVALUE = files
	  IF (Keyword_SET(files)) THEN BEGIN
	      thefile =	here + files(event.index)
	      Widget_CONTROL, selecttxt, Set_VALUE =  thefile
	      Widget_CONTROL, ok, Get_UVALUE = auto_exit
	      IF (auto_exit) THEN GOTO,	checkfile
	  EndIF
      END
      
      ok: GOTO,	checkfile
      
      selecttxt: GOTO, checkfile
      
      help: XDISPLAYFILE, "", $
		    GROUP = event.top, $
		    TITLE = "File Selection Help", $
		    WIDTH = 50,	$
		    HEIGHT = 12, $
		    TEXT = ["    This file selection widget lets you pick a ", $
			    "file.  The files are shown on the right.  You can", $
			    "select a file by clicking on it with the mouse.", $
			    "Pressing the 'OK' button will accept the choice", $
			    "and the Cancel button will not.  To move into a ",	$
			    "subdirectory, click on its name in the directory",	$
			    "list on the left.  The path can also be modified",	$
			    "to view files from a different directory.  The ", $
			    "full file name can also be typed in directly", $
			    "in the Selection area.  The list of files can be",	$
			    "modified by typing in a filter."]
      
  EndCASE
  RETURN
  
  checkfile:
  Widget_CONTROL, selecttxt, Get_VALUE = temp
  Widget_CONTROL, cancel, Get_UVALUE = existflag
  IF existflag THEN BEGIN
      ON_IOERROR, print_error
      OPENR, unit, temp(0), /GET_LUN
      FREE_LUN,	unit
  EndIF
  thefile = temp(0)
  Widget_CONTROL, event.top, /DESTROY
  RETURN
  
  print_error:
  Widget_CONTROL, selecttxt, Set_VALUE = "!!! Invalid File Name !!!"
  thefile = ""
  
END ;============= end of Cdspickfile event handling routine task ================



;------------------------------------------------------------------------------
;	procedure Cdspickfile
;------------------------------------------------------------------------------
;  This is the actual routine that creates the widget and registers it with the
;  Xmanager.  It also determines the operating system and sets the specific
;  file designators for that operating system.
;------------------------------------------------------------------------------
FUNCTION Cdspickfile, GROUP = GROUP, PATH = PATH, READ = READ, WRITE = WRITE, $
		FILTER = FILTER, TITLE = TITLE,	NOCONFIRM = NOCONFIRM, $
		MUST_EXIST = MUST_EXIST, FIX_FILTER = FIX_FILTER, $
		FILE=FILE, GET_PATH=GET_PATH,xoffset=xoffset,yoffset=yoffset
  
  common cdspicker, pathtxt, filttxt, dirlist, filelist, selecttxt, $
	  ok, cancel, help, here, thefile, separator
  
  IF(XRegistered("Cdspickfile")) THEN RETURN, 0
  
  thefile = ""
  existflag = 0
  
  IF  N_elements(xoffset) eq 0 THEN xoffset=0
  IF N_elements(yofffset) eq 0 THEN yoffset=0
  
  
  CASE !VERSION.OS OF
      'vms':	      separator	      =	''
; WINDOWS does NOT want a \ at the end of the directory 
      'windows':      separator	      =	''
      'MacOS': separator = ""
      ELSE:	      separator	      =	'/'
  EndCASE
  
  CD, CURRENT =	dirsave
  
  IF (N_elements(PATH) EQ 0) THEN BEGIN
      PATH = dirsave + separator
      here = PATH
  EndIF	ELSE BEGIN
      IF(STRPOS(PATH, separator, STRLEN(PATH) -	1) EQ -1) AND (PATH NE separator) THEN $
	PATH = PATH + separator
      CD, PATH						    ;if the user selected
      here = PATH					    ;a path then use it
  EndELSE
  
  IF (Keyword_SET(NOCONFIRM))	  THEN auto_exit = 1	  ELSE auto_exit = 0
  IF (Keyword_SET(MUST_EXIST))	  THEN existflag = 1	  ELSE existflag = 0
  IF (Keyword_SET(FIX_FILTER))	  THEN mapfilter = 0	  ELSE mapfilter = 1
  
  IF (N_elements(FILE) EQ 0)	  THEN FILE = ""
  
  IF (NOT (Keyword_SET(TITLE)))	THEN $			  ;build up the title
    TITLE = "Please Select a File"			  ;based on the keywords
  
  IF (Keyword_SET(READ)) THEN TITLE = TITLE + " for Reading" $
  ELSE IF (Keyword_SET(WRITE)) THEN TITLE = TITLE + " for Writing"
  
  CASE !VERSION.OS OF
      
      'windows':      BEGIN
	      ; Windows common dialog cdspickfile
	      ; currently does NOT support NOCONFIRM or FIX_FILTER
	  
	  ; default FILTER needs to be forced to *.* if none set 
	  IF (Keyword_SET(FILTER))	  THEN filt = FILTER ELSE filt = "*.*"
	  
	  IF (N_elements(GROUP)	EQ 0)	  THEN GROUP=0
	  
	  thefile = OS_PICKFILE( GROUP = GROUP,	FILTER = filt, TITLE = TITLE, $
				  MUST_EXIST = existflag, FILE = FILE, GET_PATH	= here)
      END
      
      'MacOS':	      BEGIN
	      ; Mac Standard File dialog pickfile
	      ; currently does NOT support FIX_FILTER
	  
	  ; default FILTER is set to "*" if none set 
	  IF (Keyword_SET(FILTER))	  THEN filt = FILTER ELSE filt = "*"
	  
	  IF (N_elements(GROUP)	EQ 0)	  THEN GROUP=0
	  
	  IF (Keyword_SET(WRITE)) THEN wr = 1 ELSE wr =	0
	  
	  IF (Keyword_SET(PATH)) THEN pth = PATH ELSE cd, current = pth
	  
	  thefile = OS_PICKFILE( GROUP = GROUP,	FILTER = filt, TITLE = TITLE, $
				  MUST_EXIST = existflag, FILE = FILE, FIX_FILTER = mapfilter, $
				  GET_PATH = here, WRITE = wr, PATH = pth)
	  
      END
      
      ELSE:   BEGIN
	      ; Widget cdspickfile for the rest of IDL
	  
	  IF (Keyword_SET(FILTER))	  THEN filt = FILTER ELSE filt = ""
	  
	  directories =	getdirs()
	  files	= getfiles(filt)
	  
	  version = Widget_INFO(/VERSION)
	  IF (version.style EQ 'Motif')	THEN osfrm = 0 ELSE osfrm = 1
	  
	  Pickfilebase =  Widget_BASE(TITLE = TITLE, /COLUMN,xoffset=xoffset,$
					  yoffset=yoffset)
	  widebase =	  Widget_BASE(Pickfilebase, /ROW)
	  label	=	  Widget_LABEL(widebase, VALUE = "Path:")
	  pathtxt =	  Widget_TEXT(widebase,	VAL = here, /EDIT, FR =	osfrm, XS = 50)
	  filtbase =	  Widget_BASE(Pickfilebase, /ROW, MAP =	mapfilter)
	  filtlbl =	  Widget_LABEL(filtbase, VALUE = "Filter:")
	  filttxt =	  Widget_TEXT(filtbase,	VAL = filt, /EDIT, XS =	10, FR = osfrm)
	  selections =	  Widget_BASE(Pickfilebase, /ROW, SPACE	= 30)
	  dirs =  Widget_BASE(selections, /COLUMN, /FRAME)
	  lbl =	  Widget_LABEL(dirs, VALUE = "Subdirectories          ")
	  dirlist =	  Widget_LIST(dirs, VALUE = directories, YSIZE = 8, $
			  UVALUE = directories)
	  fls =	  Widget_BASE(selections, /COLUMN, /FRAME)
	  lbl =	  Widget_LABEL(fls, VALUE = "Files                   ")
	  filelist =	  Widget_LIST(fls, VALUE = files, YSIZE	= 8, $
			  UVALUE = files)
	  widebase =	  Widget_BASE(Pickfilebase, /ROW)
	  label	=	  Widget_LABEL(widebase, VALUE = "Selection:")
	  selecttxt =	  Widget_TEXT(widebase,	VAL = FILE, XS = 42,	  $
			  FRAME	= osfrm, /EDIT)
	  rowbase =	  Widget_BASE(Pickfilebase, SPACE = 20,	/ROW)
	  ok =		  Widget_BUTTON(rowbase, VALUE = "     Ok     ", $
			  UVALUE = auto_exit)
	  cancel =	  Widget_BUTTON(rowbase, VALUE = "   Cancel   ", $
			  UVALUE = existflag)
	  help =  Widget_BUTTON(rowbase, VALUE = "    Help    ")
	  
	  Widget_CONTROL, Pickfilebase,	/REALIZE
	  
	  Xmanager, "Cdspickfile", Pickfilebase, EVENT_HANDLER = "Cdspickfile_ev", $
		  GROUP_LEADER = GROUP ;, /MODAL
	  bad_id = -1
	  WHILE	bad_id eq -1 DO	event=Widget_EVENT(pickfilebase,bad_id=bad_id)
      END
  EndCASE
  
  CD, dirsave
  filt = ""
  GET_PATH=here
  RETURN, thefile
  
END ;====================== end of Cdspickfile routine ===========================

